/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.common.matcher;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.power4j.fist.boot.common.matcher.PathMatcher;
import org.springframework.http.server.PathContainer;
import org.springframework.web.util.pattern.PathPattern;

public class FastPathMatcher
extends PathMatcher {
    private final Cache<String, PathPattern> pathPatterCache;
    private final Cache<String, PathContainer> pathContainerCache;

    public FastPathMatcher(int cacheSize) {
        this.pathPatterCache = Caffeine.newBuilder().maximumSize((long)cacheSize).build();
        this.pathContainerCache = Caffeine.newBuilder().maximumSize((long)cacheSize).build();
    }

    @Override
    protected PathPattern getPathPattern(String pattern) {
        return (PathPattern)this.pathPatterCache.get((Object)pattern, this::getPathPatternWithoutCache);
    }

    @Override
    protected PathContainer getPathContainer(String path) {
        return (PathContainer)this.pathContainerCache.get((Object)path, this::getPathContainerWithoutCache);
    }

    private PathPattern getPathPatternWithoutCache(String pattern) {
        return super.getPathPattern(pattern);
    }

    private PathContainer getPathContainerWithoutCache(String path) {
        return super.getPathContainer(path);
    }
}

