/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.common.matcher;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.server.PathContainer;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class PathMatcher {
    private final PathPatternParser pathPatternParser = new PathPatternParser();

    public boolean matches(String pattern, String path) {
        return this.getPathPattern(pattern).matches(this.getPathContainer(path));
    }

    public Optional<PathPattern.PathMatchInfo> match(String pattern, String path) {
        return Optional.ofNullable(this.getPathPattern(pattern).matchAndExtract(this.getPathContainer(path)));
    }

    public List<String> patternFilter(Collection<String> patterns, String path) {
        return patterns.stream().filter(o -> this.getPathPattern((String)o).matches(this.getPathContainer(path))).collect(Collectors.toList());
    }

    public <T> List<T> patternFilter(Collection<T> objects, String path, Function<T, String> patternExtractor) {
        return objects.stream().filter(o -> this.getPathPattern((String)patternExtractor.apply(o)).matches(this.getPathContainer(path))).collect(Collectors.toList());
    }

    public Optional<String> firstMatch(Collection<String> patterns, String path) {
        for (String p : patterns) {
            if (!this.getPathPattern(p).matches(this.getPathContainer(path))) continue;
            return Optional.of(p);
        }
        return Optional.empty();
    }

    public Optional<String> bestMatch(Collection<String> patterns, String path) {
        return this.patternFilter(patterns, path).stream().min(Comparator.comparing(this::getPathPattern));
    }

    public <T> Optional<T> bestMatch(Collection<T> objects, String path, Function<T, String> patternExtractor) {
        return this.patternFilter(objects, path, patternExtractor).stream().min(Comparator.comparing(o -> this.getPathPattern((String)patternExtractor.apply(o))));
    }

    protected PathPattern getPathPattern(String pattern) {
        return this.pathPatternParser.parse(pattern);
    }

    protected PathContainer getPathContainer(String path) {
        return PathContainer.parsePath((String)path);
    }
}

