/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.mon;

import com.power4j.coca.kit.common.datetime.DateTimeKit;
import com.power4j.fist.boot.mon.event.ServerErrorEvent;
import com.power4j.fist.boot.mon.info.ExceptionInfo;
import com.power4j.fist.boot.mon.info.InfoUtil;
import com.power4j.fist.boot.mon.info.TraceInfo;
import com.power4j.fist.support.spring.util.ApplicationContextHolder;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.lang.Nullable;

public final class EventUtils {
    private static final String KEY_APP_NAME = "spring.application.name";

    public static ServerErrorEvent createServerErrorEvent(@Nullable String description, Throwable e) {
        String appName = EventUtils.getAppName().orElse("Unknown");
        ServerErrorEvent errorEvent = new ServerErrorEvent();
        errorEvent.setAppName(appName);
        errorEvent.setDescription((String)ObjectUtils.defaultIfNull((Object)description, (Object)""));
        errorEvent.setTime(DateTimeKit.utcNow());
        errorEvent.setEnvInfo(InfoUtil.getEnvInfo());
        errorEvent.setError(ExceptionInfo.from(e));
        errorEvent.setTraceInfo(new TraceInfo());
        return errorEvent;
    }

    public static Optional<String> getAppName() {
        return ApplicationContextHolder.getContextOptional().map(o -> o.getEnvironment().getProperty(KEY_APP_NAME));
    }

    @Generated
    private EventUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

