/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.mon;

import com.power4j.coca.kit.common.exception.WrappedException;
import com.power4j.fist.boot.mon.EventUtils;
import com.power4j.fist.support.spring.util.SpringEventUtil;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.function.FailableRunnable;
import org.apache.commons.lang3.function.FailableSupplier;
import org.springframework.lang.Nullable;

public class Mon {
    private final List<Class<? extends Exception>> caught;
    @Nullable
    private final String description;

    public static Mon guard(List<Class<? extends Exception>> exceptions) {
        return new Mon(Objects.requireNonNull(exceptions), null);
    }

    Mon(List<Class<? extends Exception>> caught, @Nullable String description) {
        this.caught = caught;
        this.description = description;
    }

    public Mon description(String info) {
        return new Mon(this.caught, info);
    }

    public void run(FailableRunnable<Throwable> runnable) {
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            this.handleError(e);
            throw e;
        }
        catch (Exception e) {
            this.handleError(e);
            throw WrappedException.wrap((Throwable)e);
        }
        catch (Throwable e) {
            throw WrappedException.wrap((Throwable)e);
        }
    }

    public <T> T apply(FailableSupplier<T, Throwable> supplier) {
        try {
            return (T)supplier.get();
        }
        catch (RuntimeException e) {
            this.handleError(e);
            throw e;
        }
        catch (Exception e) {
            this.handleError(e);
            throw WrappedException.wrap((Throwable)e);
        }
        catch (Throwable e) {
            throw WrappedException.wrap((Throwable)e);
        }
    }

    private void handleError(Exception e) {
        if (ObjectUtils.isEmpty(this.caught)) {
            return;
        }
        for (Class<? extends Exception> clazz : this.caught) {
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            SpringEventUtil.publishEvent((Object)EventUtils.createServerErrorEvent(this.description, e));
            return;
        }
    }
}

