/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.mon.aspect;

import com.power4j.coca.kit.common.datetime.DateTimeKit;
import com.power4j.coca.kit.common.lang.Result;
import com.power4j.fist.boot.mon.ApiDescriptionResolver;
import com.power4j.fist.boot.mon.EventUtils;
import com.power4j.fist.boot.mon.annotation.ApiLog;
import com.power4j.fist.boot.mon.event.ApiLogEvent;
import com.power4j.fist.boot.mon.info.ApiResponseInfo;
import com.power4j.fist.boot.mon.info.AuthInfo;
import com.power4j.fist.boot.mon.info.ExceptionInfo;
import com.power4j.fist.boot.mon.info.ExceptionTranslator;
import com.power4j.fist.boot.mon.info.HttpRequestInfo;
import com.power4j.fist.boot.security.core.UserInfoAccessor;
import com.power4j.fist.support.spring.aop.AopUtil;
import com.power4j.fist.support.spring.util.SpringEventUtil;
import com.power4j.fist.support.spring.web.servlet.util.HttpServletRequestUtil;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

@Aspect
public class ApiLogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiLogAspect.class);
    private final ApiDescriptionResolver descriptionResolver;
    private final ExceptionTranslator exceptionTranslator;
    @Nullable
    private final UserInfoAccessor userInfoAccessor;
    private final AtomicReference<String> appNameRef = new AtomicReference<Object>(null);

    @Around(value="@annotation(apiLog)")
    public Object around(ProceedingJoinPoint point, ApiLog apiLog) throws Throwable {
        HttpRequestInfo requestInfo = HttpRequestInfo.from(HttpServletRequestUtil.getCurrentRequest());
        if (!apiLog.withQuery()) {
            requestInfo.setQueryParam("");
        }
        ApiLogEvent event = ApiLogEvent.builder().appName((String)ObjectUtils.defaultIfNull((Object)this.getAppName(), (Object)"unknown")).operation(this.getDescription(point)).requestInfo(requestInfo).time(DateTimeKit.utcNow()).authInfo(this.getAuthInfo()).build();
        try {
            Object result = point.proceed();
            event.setDuration(Duration.between(event.getTime(), DateTimeKit.utcNow()));
            try {
                this.fetchResultInfo(result, event);
                this.fire(event);
            }
            catch (Throwable any) {
                log.error(any.getMessage(), any);
            }
            return result;
        }
        catch (Exception e) {
            event.setDuration(Duration.between(event.getTime(), DateTimeKit.utcNow()));
            try {
                this.fetchErrorInfo(e, event);
                this.fire(event);
            }
            catch (Throwable any) {
                log.error(any.getMessage(), any);
            }
            throw e;
        }
    }

    AuthInfo getAuthInfo() {
        return Optional.ofNullable(this.userInfoAccessor).flatMap(UserInfoAccessor::getUserInfo).map(AuthInfo::from).orElseGet(AuthInfo::new);
    }

    void fetchResultInfo(Object result, ApiLogEvent event) {
        ApiResponseInfo responseInfo = new ApiResponseInfo();
        if (result instanceof Result) {
            Result r = (Result)result;
            responseInfo.setCode(r.getCode());
            responseInfo.setMessage(r.getMessage());
        }
        event.setResponseInfo(responseInfo);
    }

    void fetchErrorInfo(Throwable e, ApiLogEvent event) {
        this.exceptionTranslator.translateException(e).ifPresentOrElse(event::setResponseInfo, () -> event.setError(ExceptionInfo.from(e, 2000)));
    }

    String getDescription(ProceedingJoinPoint point) {
        Method method = AopUtil.getMethod((ProceedingJoinPoint)point);
        return this.descriptionResolver.resolve(method).orElse("");
    }

    @Nullable
    String getAppName() {
        String name = this.appNameRef.get();
        if (Objects.nonNull(name)) {
            return name;
        }
        EventUtils.getAppName().ifPresent(v -> this.appNameRef.compareAndSet((String)null, (String)v));
        return this.appNameRef.get();
    }

    void fire(ApiLogEvent event) {
        SpringEventUtil.publishEvent((Object)event);
    }

    @Generated
    public ApiLogAspect(ApiDescriptionResolver descriptionResolver, ExceptionTranslator exceptionTranslator, @Nullable UserInfoAccessor userInfoAccessor) {
        this.descriptionResolver = descriptionResolver;
        this.exceptionTranslator = exceptionTranslator;
        this.userInfoAccessor = userInfoAccessor;
    }
}

