/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.mon.aspect;

import com.power4j.fist.boot.mon.EventUtils;
import com.power4j.fist.boot.mon.annotation.ReportError;
import com.power4j.fist.support.spring.aop.AopUtil;
import com.power4j.fist.support.spring.spel.MethodParameterResolver;
import com.power4j.fist.support.spring.spel.SpringElUtil;
import com.power4j.fist.support.spring.spel.VariableProvider;
import com.power4j.fist.support.spring.util.SpringEventUtil;
import java.lang.reflect.Method;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.spel.standard.SpelExpressionParser;

@Aspect
public class ReportErrorAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportErrorAspect.class);
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final DefaultParameterNameDiscoverer discoverer = new DefaultParameterNameDiscoverer();

    @Around(value="@annotation(reportError)")
    public Object around(ProceedingJoinPoint point, ReportError reportError) throws Throwable {
        try {
            return point.proceed();
        }
        catch (Exception e) {
            try {
                this.handleError(point, e, reportError);
            }
            catch (Throwable any) {
                log.error(any.getMessage(), any);
            }
            throw e;
        }
    }

    void handleError(ProceedingJoinPoint point, Exception e, ReportError annotation) {
        Class<? extends Exception>[] targets = annotation.errors();
        if (ObjectUtils.isEmpty(targets)) {
            return;
        }
        String description = this.getDescription(point, annotation);
        for (Class<? extends Exception> clazz : targets) {
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            SpringEventUtil.publishEvent((Object)EventUtils.createServerErrorEvent(description, e));
            return;
        }
    }

    String getDescription(ProceedingJoinPoint point, ReportError annotation) {
        if (ObjectUtils.isNotEmpty((Object)annotation.description())) {
            return annotation.description();
        }
        String expr = annotation.descriptionExpr();
        if (ObjectUtils.isNotEmpty((Object)expr)) {
            Object[] arguments = point.getArgs();
            Method method = AopUtil.getMethod((ProceedingJoinPoint)point);
            return (String)SpringElUtil.evalWithVariable((VariableProvider)MethodParameterResolver.of((Method)method, (Object[])arguments), null, (String)expr, String.class, (Object)"");
        }
        return "";
    }
}

