/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.mon.info;

import com.power4j.fist.boot.common.error.MsgBundleRejectedException;
import com.power4j.fist.boot.common.error.RejectedException;
import com.power4j.fist.boot.mon.info.ApiResponseInfo;
import com.power4j.fist.boot.mon.info.ExceptionTranslator;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.lang.Nullable;

public class DefaultExceptionTranslator
implements ExceptionTranslator {
    @Nullable
    private final MessageSourceAccessor messageSourceAccessor;

    @Override
    public Optional<ApiResponseInfo> translateException(Throwable e) {
        if (e instanceof MsgBundleRejectedException) {
            MsgBundleRejectedException exception = (MsgBundleRejectedException)e;
            ApiResponseInfo responseInfo = new ApiResponseInfo();
            responseInfo.setCode(exception.getCode());
            responseInfo.setMessage(this.getMessage(exception));
            return Optional.of(responseInfo);
        }
        if (e instanceof RejectedException) {
            RejectedException rejectedException = (RejectedException)e;
            ApiResponseInfo responseInfo = new ApiResponseInfo();
            responseInfo.setCode(rejectedException.getCode());
            responseInfo.setMessage(rejectedException.getMessage());
            return Optional.of(responseInfo);
        }
        return Optional.empty();
    }

    String getMessage(MsgBundleRejectedException exception) {
        if (Objects.nonNull(this.messageSourceAccessor)) {
            return this.messageSourceAccessor.getMessage(exception.getMsgKey(), exception.getMsgArg(), exception.getMsgKey(), Locale.CHINA);
        }
        return exception.getMsgKey();
    }

    @Generated
    public DefaultExceptionTranslator(@Nullable MessageSourceAccessor messageSourceAccessor) {
        this.messageSourceAccessor = messageSourceAccessor;
    }
}

