/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.mon.info;

import com.power4j.fist.support.spring.web.servlet.util.HttpServletRequestUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import org.springframework.lang.Nullable;

public class HttpRequestInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String method;
    private String path;
    @Nullable
    private String queryParam;
    private String from;

    public static HttpRequestInfo from(HttpServletRequest request) {
        String method = Optional.ofNullable(request.getMethod()).map(String::toLowerCase).orElse("unknown");
        HttpRequestInfo info = new HttpRequestInfo();
        info.setMethod(method);
        info.setPath(request.getRequestURI());
        info.setQueryParam(request.getQueryString());
        info.setFrom(HttpServletRequestUtil.getRemoteIp((HttpServletRequest)request, (String)"unknown"));
        return info;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Nullable
    @Generated
    public String getQueryParam() {
        return this.queryParam;
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setQueryParam(@Nullable String queryParam) {
        this.queryParam = queryParam;
    }

    @Generated
    public void setFrom(String from) {
        this.from = from;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequestInfo)) {
            return false;
        }
        HttpRequestInfo other = (HttpRequestInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$queryParam = this.getQueryParam();
        String other$queryParam = other.getQueryParam();
        if (this$queryParam == null ? other$queryParam != null : !this$queryParam.equals(other$queryParam)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        return !(this$from == null ? other$from != null : !this$from.equals(other$from));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpRequestInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $queryParam = this.getQueryParam();
        result = result * 59 + ($queryParam == null ? 43 : $queryParam.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpRequestInfo(method=" + this.getMethod() + ", path=" + this.getPath() + ", queryParam=" + this.getQueryParam() + ", from=" + this.getFrom() + ")";
    }

    @Generated
    public HttpRequestInfo() {
    }

    @Generated
    public HttpRequestInfo(String method, String path, @Nullable String queryParam, String from) {
        this.method = method;
        this.path = path;
        this.queryParam = queryParam;
        this.from = from;
    }
}

