/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.mon.info;

import com.power4j.fist.boot.mon.info.EnvInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfoUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InfoUtil.class);
    private static final AtomicReference<EnvInfo> ENV_INFO_CACHE = new AtomicReference<Object>(null);

    public static EnvInfo getEnvInfo() {
        return ENV_INFO_CACHE.updateAndGet(o -> (EnvInfo)ObjectUtils.defaultIfNull((Object)o, (Object)InfoUtil.resolveEnvInfo()));
    }

    public static EnvInfo resolveEnvInfo() {
        EnvInfo info = new EnvInfo();
        info.setHostName(InfoUtil.getLocalHostName().orElse(null));
        info.setOsName(System.getProperty("os.name"));
        info.setOsVersion(System.getProperty("os.version"));
        info.setJvmName(System.getProperty("java.vm.name"));
        info.setJvmVersion(System.getProperty("java.vm.version"));
        return info;
    }

    private static Optional<String> getLocalHostName() {
        try {
            return Optional.ofNullable(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            log.warn("get local hostname fail", (Throwable)e);
            return Optional.empty();
        }
    }

    @Generated
    private InfoUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        CompletableFuture.runAsync(InfoUtil::getEnvInfo);
    }
}

