/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.web.reactive.log;

import java.util.Objects;
import org.reactivestreams.Subscription;
import org.slf4j.MDC;
import reactor.core.CoreSubscriber;
import reactor.util.context.Context;

public class MdcContextLifter<T>
implements CoreSubscriber<T> {
    private final CoreSubscriber<T> coreSubscriber;

    public MdcContextLifter(CoreSubscriber<T> coreSubscriber) {
        this.coreSubscriber = coreSubscriber;
    }

    public void onSubscribe(Subscription subscription) {
        this.coreSubscriber.onSubscribe(subscription);
    }

    public void onNext(T obj) {
        this.withMdc(() -> this.coreSubscriber.onNext(obj));
    }

    public void onError(Throwable t) {
        this.withMdc(() -> this.coreSubscriber.onError(t));
    }

    public void onComplete() {
        this.withMdc(() -> this.coreSubscriber.onComplete());
    }

    public Context currentContext() {
        return this.coreSubscriber.currentContext();
    }

    private void withMdc(Runnable runnable) {
        Object requestIdVal = this.coreSubscriber.currentContext().getOrDefault((Object)"mdc_request_id", null);
        if (Objects.nonNull(requestIdVal)) {
            try (MDC.MDCCloseable ignored = MDC.putCloseable((String)"requestId", (String)requestIdVal.toString());){
                runnable.run();
            }
        } else {
            runnable.run();
        }
    }
}

