/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.web.servlet;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StreamUtils;

public class CachedRequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] bodyByteArray;
    private final Map<String, String[]> parameterMap;

    public CachedRequestWrapper(HttpServletRequest request) {
        super(request);
        this.bodyByteArray = CachedRequestWrapper.getByteBody(request);
        this.parameterMap = super.getParameterMap();
    }

    public BufferedReader getReader() {
        return ObjectUtils.isEmpty((Object)this.bodyByteArray) ? null : new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.bodyByteArray);
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return byteArrayInputStream.read();
            }
        };
    }

    private static byte[] getByteBody(HttpServletRequest request) {
        byte[] body;
        try {
            body = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not read request body", e);
        }
        return body;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }
}

