/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.web.servlet.error;

import com.power4j.coca.kit.common.datetime.DateTimeKit;
import com.power4j.fist.boot.mon.info.ExceptionInfo;
import com.power4j.fist.boot.mon.info.InfoUtil;
import com.power4j.fist.boot.mon.info.TraceInfo;
import com.power4j.fist.boot.mon.info.TraceInfoResolver;
import com.power4j.fist.boot.web.event.error.HandlerErrorEvent;
import com.power4j.fist.boot.web.event.error.RequestInfo;
import com.power4j.fist.support.spring.util.ApplicationContextHolder;
import com.power4j.fist.support.spring.util.SpringEventUtil;
import com.power4j.fist.support.spring.web.servlet.util.HttpServletRequestUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class AbstractExceptionHandler {
    private TraceInfoResolver<HttpServletRequest> traceInfoResolver = request -> Optional.empty();

    @Autowired(required=false)
    public void setTraceInfoResolver(TraceInfoResolver<HttpServletRequest> traceInfoResolver) {
        this.traceInfoResolver = traceInfoResolver;
    }

    protected void doNotify(Throwable e) {
        HandlerErrorEvent event = this.createErrorEvent(e);
        if (this.filterErrorEvent(event)) {
            SpringEventUtil.publishEvent((Object)event);
        }
    }

    protected HandlerErrorEvent createErrorEvent(Throwable e) {
        String appName = ApplicationContextHolder.getContextOptional().map(ApplicationContext::getApplicationName).orElse("\u672a\u77e5\u5e94\u7528");
        TraceInfo traceInfo = HttpServletRequestUtil.getCurrentRequestIfAvailable().flatMap(o -> this.traceInfoResolver.resolve((HttpServletRequest)o)).orElse(new TraceInfo());
        HandlerErrorEvent handlerErrorEvent = new HandlerErrorEvent();
        handlerErrorEvent.setAppName(appName);
        handlerErrorEvent.setTime(DateTimeKit.utcNow());
        handlerErrorEvent.setEnvInfo(InfoUtil.getEnvInfo());
        handlerErrorEvent.setError(ExceptionInfo.from(e));
        handlerErrorEvent.setRequestInfo(RequestInfo.from(HttpServletRequestUtil.getCurrentRequest()));
        handlerErrorEvent.setTraceInfo(traceInfo);
        return handlerErrorEvent;
    }

    protected boolean filterErrorEvent(HandlerErrorEvent handlerErrorEvent) {
        return true;
    }
}

