/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.web.servlet.error;

import com.power4j.coca.kit.common.lang.Result;
import com.power4j.fist.boot.common.api.Results;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ValidationException;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.MimeType;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.NoHandlerFoundException;

@Order(value=1000)
@RestControllerAdvice
public class ClientErrorHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientErrorHandler.class);

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Result<Object> handleException(MissingServletRequestParameterException e) {
        String hint = String.format("%s(%s)", e.getParameterName(), e.getParameterType());
        log.warn("\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570:{}", (Object)hint);
        return Results.requestParameterError("\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570", hint);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Result<Object> handleException(MethodArgumentTypeMismatchException e) {
        log.warn("\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d:{}", (Object)e.getMessage());
        return Results.requestParameterError("\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d", e.getName());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Result<Object> handleException(MethodArgumentNotValidException e) {
        Optional<FieldError> error = Optional.ofNullable(e.getBindingResult().getFieldError());
        String errField = error.map(FieldError::getField).orElse(null);
        String msg = error.map(DefaultMessageSourceResolvable::getDefaultMessage).orElse("\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5931\u8d25");
        log.warn("\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5931\u8d25:{}", (Object)errField);
        return Results.requestParameterError(msg, errField);
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Result<Object> handleException(BindException e) {
        Optional<FieldError> error = Optional.ofNullable(e.getBindingResult().getFieldError());
        String errField = error.map(FieldError::getField).orElse(null);
        String msg = error.map(DefaultMessageSourceResolvable::getDefaultMessage).orElse("\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5931\u8d25");
        log.warn("\u8bf7\u6c42\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25:{}", (Object)errField);
        return Results.requestParameterError(msg, errField);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Result<Object> handleException(ConstraintViolationException e) {
        ConstraintViolation violation = (ConstraintViolation)e.getConstraintViolations().iterator().next();
        String path = violation.getPropertyPath().toString();
        log.warn("\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5931\u8d25:{}", (Object)path);
        return Results.requestParameterError(violation.getMessage(), path);
    }

    @ExceptionHandler(value={ValidationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Result<Object> handleException(ValidationException e) {
        log.warn("\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5931\u8d25:{}", (Object)e.getMessage());
        return Results.requestParameterError("\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5931\u8d25", e.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Result<Object> handleException(HttpMessageNotReadableException e) {
        log.error("\u8bf7\u6c42\u6d88\u606f\u4e0d\u80fd\u8bfb\u53d6:{}", (Object)e.getMessage());
        return Results.clientError("\u8bf7\u6c42\u6d88\u606f\u4e0d\u80fd\u8bfb\u53d6", e.getMessage());
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Result<Object> handleException(NoHandlerFoundException e) {
        String hint = String.format("%s %s", e.getHttpMethod(), e.getRequestURL());
        log.error("\u8bf7\u6c42\u8d44\u6e90\u4e0d\u5b58\u5728:{}", (Object)hint);
        return Results.clientError("\u8bf7\u6c42\u8d44\u6e90\u4e0d\u5b58\u5728", hint);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public Result<Object> handleException(HttpRequestMethodNotSupportedException e) {
        log.error("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u652f\u6301:{}", (Object)e.getMessage());
        return Results.clientError("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u652f\u6301", e.getMessage());
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    public Result<Object> handleException(HttpMediaTypeNotSupportedException e) {
        log.error("\u8bf7\u6c42\u7684\u5a92\u4f53\u7c7b\u578b\u4e0d\u652f\u6301:{}", (Object)e.getMessage());
        String hint = String.format("\u652f\u6301\u7684\u5a92\u4f53\u7c7b\u578b\u4e3a: %s", e.getSupportedMediaTypes().stream().map(MimeType::toString).collect(Collectors.joining(",")));
        return Results.clientError("\u8bf7\u6c42\u7684\u5a92\u4f53\u7c7b\u578b\u4e0d\u652f\u6301", hint);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    public Result<Object> handleException(HttpMediaTypeNotAcceptableException e) {
        String required = e.getMessage() + " " + StringUtils.join((Object[])new Object[]{",", e.getSupportedMediaTypes()});
        log.error("\u65e0\u6cd5\u54cd\u5e94\u5ba2\u6237\u7aef\u8981\u6c42\u7684\u5a92\u4f53\u7c7b\u578b:{}", (Object)required);
        String hint = String.format("\u652f\u6301\u7684\u5a92\u4f53\u7c7b\u578b\u4e3a: %s", e.getSupportedMediaTypes().stream().map(MimeType::toString).collect(Collectors.joining(",")));
        return Results.clientError("\u8bf7\u6c42\u7684\u5a92\u4f53\u7c7b\u578b\u4e0d\u652f\u6301", hint);
    }
}

