/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.web.servlet.error;

import com.power4j.coca.kit.common.lang.Result;
import com.power4j.fist.boot.common.api.Results;
import com.power4j.fist.boot.common.error.MsgBundleRejectedException;
import com.power4j.fist.boot.common.error.RejectedException;
import com.power4j.fist.boot.i18n.LocaleResolver;
import com.power4j.fist.boot.web.servlet.error.AbstractExceptionHandler;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order
@RestControllerAdvice
public class ServerErrorHandler
extends AbstractExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerErrorHandler.class);
    @Nullable
    private MessageSourceAccessor messageSourceAccessor;
    @Nullable
    private LocaleResolver localeResolver;

    @Autowired(required=false)
    public void setMessageSource(MessageSource messageSource) {
        this.messageSourceAccessor = new MessageSourceAccessor(messageSource);
    }

    @Autowired(required=false)
    public void setLocaleResolver(@Nullable LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    protected Result<?> makeResult(MsgBundleRejectedException e) {
        Locale locale = Optional.ofNullable(this.localeResolver).map(LocaleResolver::resolve).orElse(Locale.CHINA);
        String msg = Objects.requireNonNull(this.messageSourceAccessor).getMessage(e.getMsgKey(), e.getMsgArg(), e.getMsgKey(), locale);
        return Result.create((String)e.getCode(), (String)msg, null);
    }

    @ExceptionHandler(value={MsgBundleRejectedException.class})
    public ResponseEntity<Result<?>> handleException(MsgBundleRejectedException e) {
        return ResponseEntity.status((HttpStatusCode)e.getStatus()).body(this.makeResult(e));
    }

    @ExceptionHandler(value={RejectedException.class})
    public ResponseEntity<Result<?>> handleException(RejectedException e) {
        return ResponseEntity.status((HttpStatusCode)e.getStatus()).body(Results.fromError(e));
    }

    @ExceptionHandler(value={SQLException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result<Object> handleException(SQLException e) {
        log.error("\u6570\u636e\u5e93\u8bbf\u95ee\u5f02\u5e38,vendorCode = {}", (Object)e.getErrorCode(), (Object)e);
        this.doNotify(e);
        return Results.serverError(String.format("\u6570\u636e\u5e93\u8bbf\u95ee\u5f02\u5e38(%s),\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", e.getClass().getSimpleName()), "vendorCode " + e.getErrorCode());
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result<Object> handleException(Throwable e) {
        log.error(String.format("\u53d1\u751f\u672a\u5904\u7406\u5f02\u5e38(%s)", e.getClass().getName()), e);
        this.doNotify(e);
        return Results.serverError(String.format("\u670d\u52a1\u5f02\u5e38(%s),\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", e.getClass().getSimpleName()), null);
    }
}

