/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.web.servlet.mvc.formatter;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public final class DateTimeParser {
    public static final DateTimeFormatter DEFAULT_YEAR_MONTH_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM");
    public static final DateTimeFormatter DEFAULT_MONTH_DAY_FORMATTER = DateTimeFormatter.ofPattern("MM-dd");
    public static final DateTimeFormatter DEFAULT_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter DEFAULT_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter UTC_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final List<Pair<String, DateTimeFormatter>> YEAR_MONTH_FORMAT_REGISTRY = new ArrayList<Pair<String, DateTimeFormatter>>(3);
    private static final List<Pair<String, DateTimeFormatter>> MONTH_DAY_FORMAT_REGISTRY = new ArrayList<Pair<String, DateTimeFormatter>>(3);
    private static final List<Pair<String, DateTimeFormatter>> DATE_FORMAT_REGISTRY = new ArrayList<Pair<String, DateTimeFormatter>>(3);
    private static final List<Pair<String, DateTimeFormatter>> TIME_FORMAT_REGISTRY = new ArrayList<Pair<String, DateTimeFormatter>>(3);
    private static final List<Pair<String, DateTimeFormatter>> DATE_TIME_FORMAT_REGISTRY = new ArrayList<Pair<String, DateTimeFormatter>>(3);

    public static Optional<DateTimeFormatter> getYearMonthFormatter(String dateStr) {
        return DateTimeParser.getFirstMatches(YEAR_MONTH_FORMAT_REGISTRY, dateStr);
    }

    public static Optional<DateTimeFormatter> getMonthDayFormatter(String dateStr) {
        return DateTimeParser.getFirstMatches(MONTH_DAY_FORMAT_REGISTRY, dateStr);
    }

    public static Optional<DateTimeFormatter> getDateFormatter(String dateStr) {
        return DateTimeParser.getFirstMatches(DATE_FORMAT_REGISTRY, dateStr);
    }

    public static Optional<DateTimeFormatter> getTimeFormatter(String timeStr) {
        return DateTimeParser.getFirstMatches(TIME_FORMAT_REGISTRY, timeStr);
    }

    public static Optional<DateTimeFormatter> getDateTimeFormatter(String dateTimeStr) {
        return DateTimeParser.getFirstMatches(DATE_TIME_FORMAT_REGISTRY, dateTimeStr);
    }

    private static Optional<DateTimeFormatter> getFirstMatches(List<Pair<String, DateTimeFormatter>> registry, String text) {
        for (Pair<String, DateTimeFormatter> pair : registry) {
            if (!text.matches((String)pair.getKey())) continue;
            return Optional.of((DateTimeFormatter)pair.getValue());
        }
        return Optional.empty();
    }

    public static Optional<YearMonth> parseYearMonth(String text) {
        return DateTimeParser.getYearMonthFormatter(text).map(o -> YearMonth.parse(text, o));
    }

    public static Optional<MonthDay> parseMonthDay(String text) {
        return DateTimeParser.getMonthDayFormatter(text).map(o -> MonthDay.parse(text, o));
    }

    public static Optional<LocalDate> parseDate(String text) {
        return DateTimeParser.getDateFormatter(text).map(o -> LocalDate.parse(text, o));
    }

    public static Optional<LocalTime> parseTime(String text) {
        return DateTimeParser.getTimeFormatter(text).map(o -> LocalTime.parse(text, o));
    }

    public static Optional<LocalDateTime> parseDateTime(String text) {
        return DateTimeParser.getDateTimeFormatter(text).map(o -> LocalDateTime.parse(text, o));
    }

    @Generated
    private DateTimeParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        YEAR_MONTH_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{4}-\\d{2}$", (Object)DEFAULT_YEAR_MONTH_FORMATTER));
        YEAR_MONTH_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{4} {1}\\d{2}$", (Object)DateTimeFormatter.ofPattern("yyyy MM")));
        YEAR_MONTH_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{6}$", (Object)DateTimeFormatter.ofPattern("yyyyMM")));
        MONTH_DAY_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{2}-\\d{2}$", (Object)DEFAULT_MONTH_DAY_FORMATTER));
        MONTH_DAY_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{2} {1}\\d{2}$", (Object)DateTimeFormatter.ofPattern("MM dd")));
        MONTH_DAY_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{4}$", (Object)DateTimeFormatter.ofPattern("MMdd")));
        DATE_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{4}-\\d{2}-\\d{2}$", (Object)DEFAULT_DATE_FORMATTER));
        DATE_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{4} {1}\\d{2} {1}\\d{2}$", (Object)DateTimeFormatter.ofPattern("yyyy MM dd")));
        DATE_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{8}$", (Object)DateTimeFormatter.ofPattern("yyyyMMdd")));
        TIME_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{2}:\\d{2}:\\d{2}$", (Object)DEFAULT_TIME_FORMATTER));
        TIME_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{2} {1}\\d{2} {1}\\d{2}$", (Object)DateTimeFormatter.ofPattern("HH mm ss")));
        TIME_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{6}$", (Object)DateTimeFormatter.ofPattern("HHmmss")));
        DATE_TIME_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{4}-\\d{2}-\\d{2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$", (Object)DEFAULT_DATETIME_FORMATTER));
        DATE_TIME_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{4}-\\d{2}-\\d{2}.*T.*\\d{1,2}:\\d{1,2}:\\d{1,2}.*..*$", (Object)UTC_DATETIME_FORMATTER));
        DATE_TIME_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{8} {1}\\d{6}$", (Object)DateTimeFormatter.ofPattern("yyyyMMdd HHmmss")));
        DATE_TIME_FORMAT_REGISTRY.add((Pair<String, DateTimeFormatter>)Pair.of((Object)"^\\d{14}$", (Object)DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
    }
}

