/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.async;

import com.power4j.coca.kit.common.concurrent.CheckedRunnable;
import com.power4j.coca.kit.common.concurrent.CompletableFutureKit;
import com.power4j.coca.kit.common.lang.Obj;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public final class TaskKit {
    private static final Logger log = LoggerFactory.getLogger(TaskKit.class);

    public static Builder builder() {
        return new Builder();
    }

    public static void runLater(CheckedRunnable run, Consumer<Duration> onSuccess) {
        TaskKit.runLater(run, null, onSuccess, null);
    }

    public static void runLater(CheckedRunnable run, BiConsumer<Duration, Throwable> onError) {
        TaskKit.runLater(run, null, null, onError);
    }

    public static void runLater(CheckedRunnable run, Consumer<Duration> onSuccess, BiConsumer<Duration, Throwable> onError) {
        TaskKit.runLater(run, null, onSuccess, onError);
    }

    public static void runLater(CheckedRunnable runnable, @Nullable Executor executor, @Nullable Consumer<Duration> onSuccess, @Nullable BiConsumer<Duration, Throwable> onError) {
        Builder builder = new Builder().successCallback(onSuccess).errorCallback(onError).executor(executor);
        builder.run(runnable);
    }

    private TaskKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Builder {
        @Nullable
        private Consumer<Duration> successCallback;
        @Nullable
        private BiConsumer<Duration, Throwable> errorCallback;
        @Nullable
        private Executor executor;

        Builder() {
        }

        public Builder successCallback(@Nullable Consumer<Duration> successCallback) {
            this.successCallback = successCallback;
            return this;
        }

        public Builder errorCallback(@Nullable BiConsumer<Duration, Throwable> errorCallback) {
            this.errorCallback = errorCallback;
            return this;
        }

        public Builder executor(@Nullable Executor executor) {
            this.executor = executor;
            return this;
        }

        public CompletableFuture<Instant> run(CheckedRunnable runnable) {
            Consumer<Duration> successHandler = this.successCallback;
            BiConsumer<Duration, Throwable> errorHandler = this.errorCallback;
            return CompletableFutureKit.supplyAsync(() -> {
                Instant startAt = Instant.now();
                try {
                    runnable.run();
                    if (Objects.nonNull(successHandler)) {
                        successHandler.accept(Duration.between(startAt, Instant.now()));
                    }
                }
                catch (Exception e) {
                    if (Objects.nonNull(errorHandler)) {
                        errorHandler.accept(Duration.between(startAt, Instant.now()), e);
                    }
                    throw new CompletionException(e.getMessage(), e);
                }
                return startAt;
            }, Obj.keepIfNotNull(this.executor, ForkJoinPool::commonPool));
        }
    }
}

