/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.collection.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public final class TreeUtil {
    public static <ID, T> Map<ID, T> findAncestors(Map<ID, T> source, Function<? super T, ID> idGetter, Function<? super T, ID> pidGetter) {
        HashMap<ID, T> output = new HashMap<ID, T>(8);
        HashSet skipSet = new HashSet(8);
        for (T node : source.values()) {
            if (skipSet.contains(idGetter.apply(node))) continue;
            T ancestor = TreeUtil.findAncestor(source, node, skipSet, idGetter, pidGetter);
            output.put(idGetter.apply(ancestor), ancestor);
        }
        return output;
    }

    static <ID, T> T findAncestor(Map<ID, T> source, T child, Set<ID> skipSet, Function<? super T, ID> idGetter, Function<? super T, ID> pidGetter) {
        T parent = source.get(pidGetter.apply(child));
        if (Objects.nonNull(parent)) {
            skipSet.add(idGetter.apply(child));
            return TreeUtil.findAncestor(source, parent, skipSet, idGetter, pidGetter);
        }
        return child;
    }

    public static <ID, T> void fetch(Collection<T> source, Collection<T> roots, NodeOp<ID, T> nodeOp) {
        Map sourceMap = source.stream().collect(Collectors.toMap(((NodeOp)nodeOp).idGetter, Function.identity(), (x, y) -> y, LinkedHashMap::new));
        Map rootMap = roots.stream().collect(Collectors.toMap(((NodeOp)nodeOp).idGetter, Function.identity(), (x, y) -> y, LinkedHashMap::new));
        TreeUtil.fetch(sourceMap, rootMap, nodeOp);
    }

    public static <ID, T> void fetch(Map<ID, T> source, Map<ID, T> roots, NodeOp<ID, T> nodeOp) {
        if (roots.isEmpty()) {
            return;
        }
        for (T node : source.values()) {
            Object parentId;
            Object parentNode;
            Object id;
            if (null == node || roots.containsKey(id = Objects.requireNonNull(((NodeOp)nodeOp).idGetter.apply(node))) || null == (parentNode = Optional.ofNullable(roots.get(parentId = ((NodeOp)nodeOp).pidGetter.apply(node))).orElseGet(() -> source.get(parentId)))) continue;
            ((NodeOp)nodeOp).childConsumer.accept(parentNode, node);
        }
    }

    public static <ID, T> void treeWalk(Collection<? extends T> roots, AccessOp<ID, T> accessOp, Consumer<? super T> consumer) {
        for (T node : roots) {
            consumer.accept(node);
            Collection children = (Collection)((AccessOp)accessOp).childrenGetter.apply(node);
            if (!ObjectUtils.isNotEmpty((Object)children)) continue;
            TreeUtil.treeWalk(children, accessOp, consumer);
        }
    }

    public static <ID, T> List<T> flatten(Collection<T> roots, AccessOp<ID, T> accessOp) {
        ArrayList list = new ArrayList(roots.size());
        TreeUtil.treeWalk(roots, accessOp, list::add);
        return list;
    }

    private TreeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class AccessOp<ID, T> {
        private final Function<? super T, ID> idGetter;
        private final Function<? super T, ID> pidGetter;
        private final Function<? super T, Collection<T>> childrenGetter;

        AccessOp(Function<? super T, ID> idGetter, Function<? super T, ID> pidGetter, Function<? super T, Collection<T>> childrenGetter) {
            this.idGetter = idGetter;
            this.pidGetter = pidGetter;
            this.childrenGetter = childrenGetter;
        }

        public static <ID, T> AccessOpBuilder<ID, T> builder() {
            return new AccessOpBuilder();
        }

        public Function<? super T, ID> getIdGetter() {
            return this.idGetter;
        }

        public Function<? super T, ID> getPidGetter() {
            return this.pidGetter;
        }

        public Function<? super T, Collection<T>> getChildrenGetter() {
            return this.childrenGetter;
        }

        public static class AccessOpBuilder<ID, T> {
            private Function<? super T, ID> idGetter;
            private Function<? super T, ID> pidGetter;
            private Function<? super T, Collection<T>> childrenGetter;

            AccessOpBuilder() {
            }

            public AccessOpBuilder<ID, T> idGetter(Function<? super T, ID> idGetter) {
                this.idGetter = idGetter;
                return this;
            }

            public AccessOpBuilder<ID, T> pidGetter(Function<? super T, ID> pidGetter) {
                this.pidGetter = pidGetter;
                return this;
            }

            public AccessOpBuilder<ID, T> childrenGetter(Function<? super T, Collection<T>> childrenGetter) {
                this.childrenGetter = childrenGetter;
                return this;
            }

            public AccessOp<ID, T> build() {
                return new AccessOp<ID, T>(this.idGetter, this.pidGetter, this.childrenGetter);
            }

            public String toString() {
                return "TreeUtil.AccessOp.AccessOpBuilder(idGetter=" + this.idGetter + ", pidGetter=" + this.pidGetter + ", childrenGetter=" + this.childrenGetter + ")";
            }
        }
    }

    public static class NodeOp<ID, T> {
        private final Function<? super T, ID> idGetter;
        private final Function<? super T, ID> pidGetter;
        private final BiConsumer<? super T, T> childConsumer;

        NodeOp(Function<? super T, ID> idGetter, Function<? super T, ID> pidGetter, BiConsumer<? super T, T> childConsumer) {
            this.idGetter = idGetter;
            this.pidGetter = pidGetter;
            this.childConsumer = childConsumer;
        }

        public static <ID, T> NodeOpBuilder<ID, T> builder() {
            return new NodeOpBuilder();
        }

        public Function<? super T, ID> getIdGetter() {
            return this.idGetter;
        }

        public Function<? super T, ID> getPidGetter() {
            return this.pidGetter;
        }

        public BiConsumer<? super T, T> getChildConsumer() {
            return this.childConsumer;
        }

        public static class NodeOpBuilder<ID, T> {
            private Function<? super T, ID> idGetter;
            private Function<? super T, ID> pidGetter;
            private BiConsumer<? super T, T> childConsumer;

            NodeOpBuilder() {
            }

            public NodeOpBuilder<ID, T> idGetter(Function<? super T, ID> idGetter) {
                this.idGetter = idGetter;
                return this;
            }

            public NodeOpBuilder<ID, T> pidGetter(Function<? super T, ID> pidGetter) {
                this.pidGetter = pidGetter;
                return this;
            }

            public NodeOpBuilder<ID, T> childConsumer(BiConsumer<? super T, T> childConsumer) {
                this.childConsumer = childConsumer;
                return this;
            }

            public NodeOp<ID, T> build() {
                return new NodeOp<ID, T>(this.idGetter, this.pidGetter, this.childConsumer);
            }

            public String toString() {
                return "TreeUtil.NodeOp.NodeOpBuilder(idGetter=" + this.idGetter + ", pidGetter=" + this.pidGetter + ", childConsumer=" + this.childConsumer + ")";
            }
        }
    }
}

