/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class CompressUtil {
    public static void gzip(int buffSize, InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buff = new byte[buffSize];
        try (GZIPOutputStream gzip = new GZIPOutputStream(outputStream);){
            int read;
            while ((read = inputStream.read(buff)) != -1) {
                gzip.write(buff, 0, read);
            }
        }
    }

    public static void gzip(byte[] source, OutputStream outputStream) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(source);){
            CompressUtil.gzip(2048, inputStream, outputStream);
        }
    }

    public static byte[] gzip(byte[] source) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream(source.length);){
            CompressUtil.gzip(source, os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public static void unGzip(int buffSize, InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buff = new byte[buffSize];
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);){
            int read;
            while ((read = gzipInputStream.read(buff)) != -1) {
                outputStream.write(buff, 0, read);
            }
        }
    }

    public static void unGzip(byte[] source, OutputStream outputStream) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(source);){
            CompressUtil.unGzip(2048, byteArrayInputStream, outputStream);
        }
    }

    public static byte[] unGzip(byte[] source) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(source.length);
        CompressUtil.unGzip(source, os);
        return os.toByteArray();
    }

    private CompressUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

