/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.datetime;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import org.springframework.lang.Nullable;

public final class DateTimeKit {
    public static final LocalDateTime EPOCH = LocalDateTime.of(1970, 1, 1, 0, 0, 0);
    public static final LocalDateTime FOREVER = LocalDateTime.of(9999, 12, 31, 23, 59, 59);

    public static LocalDateTime utcNow() {
        return LocalDateTime.now(ZoneOffset.UTC);
    }

    @Nullable
    public static Date toDate(@Nullable LocalDateTime localDateTime) {
        return DateTimeKit.toDate(localDateTime, ZoneId.systemDefault());
    }

    @Nullable
    public static LocalDateTime toLocalDateTime(@Nullable Date date) {
        return DateTimeKit.toLocalDateTime(date, ZoneId.systemDefault());
    }

    @Nullable
    public static Date toDate(@Nullable LocalDateTime localDateTime, ZoneId zoneId) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(zoneId).toInstant());
    }

    @Nullable
    public static LocalDateTime toLocalDateTime(@Nullable Date date, ZoneId zoneId) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(zoneId).toLocalDateTime();
    }

    @Nullable
    public static Date toDate(@Nullable LocalDateTime localDateTime, ZoneOffset offset) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atOffset(offset).toInstant());
    }

    @Nullable
    public static LocalDateTime toLocalDateTime(@Nullable Date date, ZoneOffset offset) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atOffset(offset).toLocalDateTime();
    }

    @Nullable
    public static ZonedDateTime toZonedDateTime(@Nullable LocalDateTime dateTime, ZoneId zoneId) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.atZone(zoneId);
    }

    @Nullable
    public static OffsetDateTime toOffsetDateTime(@Nullable LocalDateTime dateTime, ZoneOffset offset) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.atOffset(offset);
    }

    @Nullable
    public static ZonedDateTime toZonedDateTimeUtc(@Nullable LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return DateTimeKit.toZonedDateTime(dateTime, ZoneOffset.UTC);
    }

    @Nullable
    public static LocalDateTime toLocalDateTime(@Nullable ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.toLocalDateTime();
    }

    private DateTimeKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

