/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.io.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.springframework.lang.Nullable;

public class AbstractBufferAccess {
    protected static final byte STR_END = 0;
    protected static final byte BYTE_ZERO = 0;
    protected static final int NOT_FOUND = -1;
    protected ByteBuffer buffer;

    public AbstractBufferAccess(ByteBuffer buffer, @Nullable ByteOrder order) {
        this.buffer = buffer;
        if (Objects.nonNull(order)) {
            this.buffer.order(order);
        }
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer getBufferCopy() {
        return this.buffer.duplicate();
    }

    public static int firstPos(byte[] src, byte val) {
        int pos = 0;
        while (pos < src.length) {
            if (src[pos++] != val) continue;
            return pos;
        }
        return -1;
    }

    protected void expand(int newCapacity) {
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }
}

