/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.io.buffer;

import com.power4j.coca.kit.common.io.buffer.AbstractBufferAccess;
import com.power4j.coca.kit.common.io.buffer.BufferReader;
import com.power4j.coca.kit.common.io.buffer.ByteOrderAccess;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.codec.binary.Hex;
import org.springframework.lang.Nullable;

public class ByteBufferReader
extends AbstractBufferAccess
implements BufferReader<ByteBufferReader>,
ByteOrderAccess<ByteBufferReader> {
    public static ByteBufferReader of(ByteBuffer buffer, ByteOrder order) {
        return new ByteBufferReader(buffer, order);
    }

    public static ByteBufferReader of(ByteBuffer buffer) {
        return new ByteBufferReader(buffer, null);
    }

    ByteBufferReader(ByteBuffer buffer, @Nullable ByteOrder order) {
        super(buffer.asReadOnlyBuffer(), order);
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public ByteBufferReader order(ByteOrder order) {
        this.buffer.order(order);
        return this;
    }

    @Override
    public byte readByte() {
        return this.buffer.get();
    }

    @Override
    public char readChar() {
        return this.buffer.getChar();
    }

    @Override
    public byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        this.buffer.get(bytes);
        return bytes;
    }

    @Override
    public void transfer(byte[] dest, int offset, int length) {
        if (length > this.readableBytes()) {
            throw new BufferUnderflowException();
        }
        while (length-- > 0) {
            dest[offset++] = this.readByte();
        }
    }

    @Override
    public short readShort() {
        return this.buffer.getShort();
    }

    @Override
    public int readInt() {
        return this.buffer.getInt();
    }

    @Override
    public long readLong() {
        return this.buffer.getLong();
    }

    @Override
    public float readFloat() {
        return this.buffer.getFloat();
    }

    @Override
    public double readDouble() {
        return this.buffer.getDouble();
    }

    @Override
    public String readAsString(int length, Charset charset) {
        return this.readString(length, charset, false);
    }

    @Override
    public String readString(int length, Charset charset, boolean dropTail) {
        int pos;
        byte[] raw = this.readBytes(length);
        if (dropTail && (pos = ByteBufferReader.firstPos(raw, (byte)0)) != -1) {
            return new String(raw, 0, pos - 1, charset);
        }
        return new String(raw, charset);
    }

    @Override
    public String readUtf8String(int length) {
        return this.readString(length, StandardCharsets.UTF_8, true);
    }

    @Override
    public int readableBytes() {
        return this.buffer.remaining();
    }

    @Override
    public int hasRead() {
        return this.buffer.position();
    }

    @Override
    public ByteBufferReader unread(int length) {
        if (length > 0) {
            int pos = this.buffer.position() - length;
            this.buffer.position(Math.max(pos, 0));
        }
        return this;
    }

    @Override
    public ByteBufferReader unreadAll() {
        return this.unread(this.readableBytes());
    }

    @Override
    public ByteBufferReader skip(int length) {
        if (length > 0) {
            int pos = this.buffer.position() + length;
            this.buffer.position(Math.min(pos, this.buffer.limit()));
        }
        return this;
    }

    @Override
    public String dumpHex() {
        int size = this.readableBytes();
        if (size > 0) {
            return Hex.encodeHexString((byte[])this.readBytes(size));
        }
        return "";
    }

    @Override
    public String dumpBase64() {
        int size = this.readableBytes();
        if (size > 0) {
            return Base64.getEncoder().encodeToString(this.readBytes(size));
        }
        return "";
    }

    @Override
    protected void expand(int newCapacity) {
        throw new ReadOnlyBufferException();
    }
}

