/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.io.buffer;

import com.power4j.coca.kit.common.io.buffer.AbstractBufferAccess;
import com.power4j.coca.kit.common.io.buffer.BufferWriter;
import com.power4j.coca.kit.common.io.buffer.ByteOrderAccess;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.springframework.lang.Nullable;

public class ByteBufferWriter
extends AbstractBufferAccess
implements BufferWriter<ByteBufferWriter>,
ByteOrderAccess<ByteBufferWriter> {
    public static ByteBufferWriter of(ByteBuffer buffer, ByteOrder order) {
        return new ByteBufferWriter(buffer, order);
    }

    public static ByteBufferWriter of(ByteBuffer buffer) {
        return new ByteBufferWriter(buffer, null);
    }

    ByteBufferWriter(ByteBuffer buffer, @Nullable ByteOrder order) {
        super(buffer, order);
    }

    @Override
    public ByteBufferWriter writeByte(byte b) {
        this.buffer.put(b);
        return this;
    }

    @Override
    public ByteBufferWriter writeByteRepeat(byte b, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count \u4e0d\u80fd\u5c0f\u4e8e0");
        }
        while (count-- > 0) {
            this.buffer.put(b);
        }
        return this;
    }

    @Override
    public ByteBufferWriter writeChar(char val) {
        this.buffer.putChar(val);
        return this;
    }

    @Override
    public ByteBufferWriter writeBytes(byte[] src, int offset, int length) {
        this.buffer.put(src, offset, length);
        return this;
    }

    @Override
    public ByteBufferWriter writeShort(short val) {
        this.buffer.putShort(val);
        return this;
    }

    @Override
    public ByteBufferWriter writeInt(int val) {
        this.buffer.putInt(val);
        return this;
    }

    @Override
    public ByteBufferWriter writeLong(long val) {
        this.buffer.putLong(val);
        return this;
    }

    @Override
    public ByteBufferWriter writeFloat(float val) {
        this.buffer.putFloat(val);
        return this;
    }

    @Override
    public ByteBufferWriter writeDouble(double val) {
        this.buffer.putDouble(val);
        return this;
    }

    @Override
    public ByteBufferWriter writeString(String str, Charset charset, int fixedSize, byte filler) {
        byte[] raw = str.getBytes(charset);
        if (raw.length < fixedSize) {
            int fillPos = raw.length;
            raw = Arrays.copyOf(raw, fixedSize);
            if (filler != 0) {
                while (fillPos < raw.length) {
                    raw[fillPos++] = filler;
                }
            }
        }
        this.buffer.put(raw);
        return this;
    }

    @Override
    public ByteBufferWriter writeFixedString(String str, int fixedSize) {
        return this.writeString(str, StandardCharsets.UTF_8, fixedSize, (byte)0);
    }

    @Override
    public ByteBufferWriter discard(int length) {
        if (length > 0) {
            int result = Math.min(this.buffer.position(), length);
            this.buffer.position(this.buffer.position() - result);
        }
        return this;
    }

    @Override
    public ByteBufferWriter discardAll() {
        return this.discard(this.hasWritten());
    }

    @Override
    public ByteBufferWriter reserve(int length) {
        if (length > 0) {
            this.buffer.position(Math.min(this.buffer.position() + length, this.buffer.capacity()));
        }
        return this;
    }

    @Override
    public int hasWritten() {
        return this.buffer.position();
    }

    @Override
    public int writeableBytes() {
        return this.buffer.capacity() - this.buffer.position();
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public ByteBufferWriter order(ByteOrder order) {
        this.buffer.order(order);
        return this;
    }
}

