/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.io.codec.impl;

import com.power4j.coca.kit.common.compress.CompressUtil;
import com.power4j.coca.kit.common.io.codec.Codec;
import com.power4j.coca.kit.common.io.codec.CodecException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BufferGz
implements Codec<ByteBuffer, ByteBuffer> {
    public static final String NAME = "gz";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public ByteBuffer decode(ByteBuffer src) throws CodecException {
        try {
            byte[] data = CompressUtil.unGzip(src.array());
            return ByteBuffer.wrap(data);
        }
        catch (IOException e) {
            throw new CodecException(e.getMessage(), e);
        }
    }

    @Override
    public ByteBuffer encode(ByteBuffer src) throws CodecException {
        try {
            byte[] data = CompressUtil.gzip(src.array());
            return ByteBuffer.wrap(data);
        }
        catch (IOException e) {
            throw new CodecException(e.getMessage(), e);
        }
    }
}

