/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.lang;

import com.power4j.coca.kit.common.exception.AssertionFailException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.lang.Nullable;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String code;
    @Nullable
    private String message;
    @Nullable
    private T data;
    @Nullable
    private Map<String, Object> metaInfo;

    public static Builder ofCode(String code) {
        return new Builder(code);
    }

    public static <T> Result<T> create(String code, @Nullable String message, @Nullable T data, @Nullable Map<String, Object> metaInfo) {
        Result<T> result = new Result<T>();
        result.setCode(code);
        result.setMessage(message);
        result.setData(data);
        result.setMetaInfo(metaInfo);
        return result;
    }

    public static <T> Result<T> create(String code, @Nullable String message, @Nullable T data) {
        return Result.create(code, message, data, null);
    }

    public boolean codeEquals(@Nullable String expected, boolean caseSensitive) {
        return caseSensitive ? this.code.equals(expected) : this.code.equalsIgnoreCase(expected);
    }

    public boolean codeNotEquals(@Nullable String expected, boolean caseSensitive) {
        return !this.codeEquals(expected, caseSensitive);
    }

    public boolean codeEquals(@Nullable String expected) {
        return this.codeEquals(expected, true);
    }

    public boolean codeNotEquals(@Nullable String expected) {
        return !this.codeEquals(expected, true);
    }

    @Nullable
    public <E extends Exception> T checkAndGetData(Predicate<String> codePredicate, Function<Result<T>, E> func) throws E {
        if (codePredicate.test(this.code)) {
            return this.data;
        }
        throw (Exception)func.apply(this);
    }

    public T requiredData() {
        if (Objects.isNull(this.data)) {
            throw new AssertionFailException("Data is null (" + this.simpleDescribe() + ")");
        }
        return this.data;
    }

    public <U> Result<U> map(Function<T, U> func) {
        return Result.create(this.code, this.message, func.apply(this.data), this.metaInfo);
    }

    public <U> Result<U> mapIfPresent(Function<T, U> func) {
        return Result.create(this.code, this.message, Objects.nonNull(this.data) ? (T)func.apply(this.data) : null, this.metaInfo);
    }

    public <U> Result<U> mapOnCode(Predicate<String> codePredicate, Function<T, U> func) {
        if (codePredicate.test(this.code)) {
            return Result.create(this.code, this.message, func.apply(this.data), this.metaInfo);
        }
        return Result.create(this.code, this.message, null, this.metaInfo);
    }

    public String simpleDescribe() {
        return "code = " + this.code + ",msg = " + this.message;
    }

    public String getCode() {
        return this.code;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public T getData() {
        return this.data;
    }

    @Nullable
    public Map<String, Object> getMetaInfo() {
        return this.metaInfo;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    public void setData(@Nullable T data) {
        this.data = data;
    }

    public void setMetaInfo(@Nullable Map<String, Object> metaInfo) {
        this.metaInfo = metaInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Map<String, Object> this$metaInfo = this.getMetaInfo();
        Map<String, Object> other$metaInfo = other.getMetaInfo();
        return !(this$metaInfo == null ? other$metaInfo != null : !((Object)this$metaInfo).equals(other$metaInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Map<String, Object> $metaInfo = this.getMetaInfo();
        result = result * 59 + ($metaInfo == null ? 43 : ((Object)$metaInfo).hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", metaInfo=" + this.getMetaInfo() + ")";
    }

    public static class Builder {
        private final String code;
        @Nullable
        private String message;
        @Nullable
        private Map<String, Object> metaInfo;

        public Builder(String code) {
            this.code = Objects.requireNonNull(code);
        }

        public Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        public Builder pushMeta(String key, Object value) {
            this.useMeta().put(key, value);
            return this;
        }

        public Builder pushMeta(@Nullable Map<String, Object> map) {
            if (map == null) {
                return this;
            }
            this.useMeta().putAll(map);
            return this;
        }

        public <T> Result<T> build(@Nullable T data) {
            return Result.create(this.code, this.message, data, this.metaInfo);
        }

        protected Map<String, Object> useMeta() {
            if (this.metaInfo == null) {
                this.metaInfo = new HashMap<String, Object>(4);
            }
            return this.metaInfo;
        }
    }
}

