/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.codec.binary;

import java.math.BigInteger;

public class BCD {
    private static final int MAX_NUMBER = 10;
    private static final int COMPRESS = 2;

    public static byte[] encode(String value) {
        int j;
        int i;
        if (!BCD.isBcdString(value)) {
            throw new IllegalArgumentException("Can only encode numerical strings");
        }
        byte[] bcd = new byte[(value.length() + 1) / 2];
        if (value.length() % 2 == 1) {
            bcd[0] = (byte)(value.codePointAt(0) & 0xF);
            i = 1;
            j = 1;
        } else {
            i = 0;
            j = 0;
        }
        while (i < bcd.length) {
            bcd[i] = (byte)((value.codePointAt(j) & 0xF) << 4 | value.codePointAt(j + 1) & 0xF);
            ++i;
            j += 2;
        }
        return bcd;
    }

    public static byte[] encode(BigInteger value) {
        if (value.signum() == -1) {
            throw new IllegalArgumentException("Only non-negative values are supported");
        }
        if (value.bitLength() > 63) {
            return BCD.encode(value.toString());
        }
        return BCD.encode(value.longValue());
    }

    public static byte[] encode(BigInteger value, int length) {
        if (value.signum() == -1) {
            throw new IllegalArgumentException("Only non-negative values are supported");
        }
        if (value.bitLength() > length * 8) {
            throw new IllegalArgumentException("Value does not fit in byte array of length" + length);
        }
        if (value.bitLength() > 63) {
            return BCD.encode(String.format("%0" + length * 2 + "d", value));
        }
        return BCD.encode(value.longValue(), length);
    }

    public static byte[] encode(long value, int length) {
        if (value < 0L) {
            throw new IllegalArgumentException("Only non-negative values are supported");
        }
        if (value == 0L) {
            return new byte[length];
        }
        byte[] bcd = new byte[length];
        for (int i = bcd.length - 1; i >= 0; --i) {
            int b = (int)(value % 10L);
            b = (int)((long)b | (value /= 10L) % 10L << 4);
            value /= 10L;
            bcd[i] = (byte)b;
        }
        if (value != 0L) {
            throw new IllegalArgumentException("Value does not fit in byte array of length " + length);
        }
        return bcd;
    }

    public static byte[] encode(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Only non-negative values are supported");
        }
        if (value == 0L) {
            return new byte[1];
        }
        int length = (int)Math.log10(value) + 1;
        return BCD.encode(value, (length + 1) / 2);
    }

    public static BigInteger decode(byte[] bcd) {
        BigInteger value = BigInteger.ZERO;
        for (int i = 0; i < bcd.length; ++i) {
            int high = (bcd[i] & 0xFF) >> 4;
            int low = bcd[i] & 0xF;
            if (high > 10 || low > 10) {
                throw new IllegalArgumentException(String.format("Illegal byte %x%x at %d", high, low, i));
            }
            value = value.multiply(BigInteger.TEN).add(BigInteger.valueOf(high));
            value = value.multiply(BigInteger.TEN).add(BigInteger.valueOf(low));
        }
        return value;
    }

    public static String decodeAsString(byte[] bcd, boolean stripLeadingZero) {
        StringBuilder buf = new StringBuilder(bcd.length * 2);
        for (int i = 0; i < bcd.length; ++i) {
            int high = (bcd[i] & 0xFF) >> 4;
            int low = bcd[i] & 0xF;
            if (high > 10 || low > 10) {
                throw new IllegalArgumentException(String.format("Illegal byte %x%x at %d", high, low, i));
            }
            buf.append((char)(0x30 | high));
            buf.append((char)(0x30 | low));
        }
        return stripLeadingZero && buf.charAt(0) == '0' ? buf.substring(1) : buf.toString();
    }

    public static boolean isBcdString(CharSequence cs) {
        if (cs.length() == 0) {
            return false;
        }
        return !cs.chars().filter(c -> !BCD.isBcdChar(c)).findFirst().isPresent();
    }

    public static boolean isBcdChar(int ch) {
        return 48 <= ch && ch <= 57;
    }
}

