/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.concurrent;

import com.power4j.coca.kit.common.concurrent.CheckedRunnable;
import com.power4j.coca.kit.common.util.function.CheckedSupplier;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;

public class CompletableFutureKit {
    public static CompletableFuture<Void> runAsync(CheckedRunnable runnable, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw new CompletionException(e.getMessage(), e);
            }
        }, executor);
    }

    public static CompletableFuture<Void> runAsync(CheckedRunnable runnable) {
        return CompletableFuture.runAsync(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw new CompletionException(e.getMessage(), e);
            }
        });
    }

    public static <U> CompletableFuture<U> supplyAsync(CheckedSupplier<U> supplier, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return supplier.apply();
            }
            catch (Exception e) {
                throw new CompletionException(e.getMessage(), e);
            }
        }, executor);
    }

    public static <U> CompletableFuture<U> supplyAsync(CheckedSupplier<U> supplier) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return supplier.apply();
            }
            catch (Exception e) {
                throw new CompletionException(e.getMessage(), e);
            }
        });
    }
}

