/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.io.buffer;

import java.nio.ByteBuffer;
import lombok.Generated;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public final class BufferKit {
    public static ByteBuffer allocate(int length) {
        return ByteBuffer.allocate(length);
    }

    public static ByteBuffer wrap(byte[] buf, int offset, int length) {
        return ByteBuffer.wrap(buf, offset, length);
    }

    public static ByteBuffer wrap(byte[] buf) {
        return BufferKit.wrap(buf, 0, buf.length);
    }

    public static ByteBuffer copyFrom(byte[] buf, int offset, int length) {
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.put(buf, offset, length);
        return buffer;
    }

    public static ByteBuffer copyFrom(byte[] buf) {
        return BufferKit.copyFrom(buf, 0, buf.length);
    }

    public static ByteBuffer copyToFit(byte[] buf, int size, int filler) {
        if (size <= buf.length) {
            return BufferKit.copyFrom(buf, 0, size);
        }
        ByteBuffer buffer = BufferKit.allocate(size);
        buffer.put(buf);
        for (int i = buf.length; i < size; ++i) {
            buffer.put((byte)filler);
        }
        return buffer;
    }

    public static ByteBuffer fromHex(String hexStr) {
        try {
            return BufferKit.wrap(Hex.decodeHex((String)hexStr));
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ByteBuffer fromBase64(String base64Str) {
        return BufferKit.wrap(Base64.decodeBase64((String)base64Str));
    }

    @Generated
    private BufferKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

