/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.io.buffer;

import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.apache.commons.codec.binary.Hex;
import org.springframework.lang.Nullable;

public class ByteBufferReader {
    private static final BigInteger U64_MASK = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    protected static final byte STR_END = 0;
    protected static final int NOT_FOUND = -1;
    protected ByteBuffer buffer;

    public static ByteBufferReader of(ByteBuffer buffer, @Nullable ByteOrder order) {
        return new ByteBufferReader(buffer, order);
    }

    public static ByteBufferReader of(ByteBuffer buffer) {
        return new ByteBufferReader(buffer, null);
    }

    ByteBufferReader(ByteBuffer buffer, @Nullable ByteOrder order) {
        this.buffer = buffer.asReadOnlyBuffer();
        if (Objects.nonNull(order)) {
            this.buffer.order(order);
        }
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public ByteBufferReader order(ByteOrder order) {
        this.buffer.order(order);
        return this;
    }

    public char readChar() {
        return this.buffer.getChar();
    }

    public byte[] readOrFill(int length, byte val, boolean padLeft) {
        int readable = this.readableBytes();
        if (length > readable) {
            byte[] bytes = new byte[length];
            if (padLeft) {
                Arrays.fill(bytes, 0, length - readable, val);
                this.transfer(bytes, length - readable, readable);
            } else {
                this.transfer(bytes, 0, readable);
                Arrays.fill(bytes, readable, length, val);
            }
            return bytes;
        }
        return this.readBytes(length);
    }

    public byte[] readBytes(int size) {
        byte[] bytes = new byte[size];
        this.buffer.get(bytes);
        return bytes;
    }

    public byte readByte() {
        return this.buffer.get();
    }

    public short readShort() {
        return this.buffer.getShort();
    }

    public int readInt() {
        return this.buffer.getInt();
    }

    public long readLong() {
        return this.buffer.getLong();
    }

    public int readU8() {
        return Byte.toUnsignedInt(this.buffer.get());
    }

    public int readU16() {
        return Short.toUnsignedInt(this.buffer.getShort());
    }

    public long readU32() {
        return Integer.toUnsignedLong(this.buffer.getInt());
    }

    public BigInteger readU64() {
        return BigInteger.valueOf(this.buffer.getLong()).and(U64_MASK);
    }

    public float readFloat() {
        return this.buffer.getFloat();
    }

    public double readDouble() {
        return this.buffer.getDouble();
    }

    public String readString(int length, Charset charset, boolean dropTail) {
        int pos;
        byte[] raw = this.readBytes(length);
        if (dropTail && (pos = ByteBufferReader.findFirst(raw, (byte)0)) != -1) {
            return new String(raw, 0, pos - 1, charset);
        }
        return new String(raw, charset);
    }

    public String readString(int length) {
        return this.readString(length, StandardCharsets.UTF_8, true);
    }

    public String readUnicodeString(int length, Charset charset, boolean dropTail) {
        byte[] raw = this.readBytes(length);
        if (dropTail) {
            for (int i = 0; i < length; i += 2) {
                if (raw[i] != 0 || raw[i + 1] != 0) continue;
                return new String(raw, 0, i, charset);
            }
        }
        return new String(raw, charset);
    }

    public ByteBufferReader transfer(byte[] dest, int offset, int length) {
        if (length > this.readableBytes()) {
            throw new BufferUnderflowException();
        }
        while (length-- > 0) {
            dest[offset++] = this.readByte();
        }
        return this;
    }

    public ByteBufferReader transfer(byte[] dest) {
        return this.transfer(dest, 0, dest.length);
    }

    public int readableBytes() {
        return this.buffer.remaining();
    }

    public int hasRead() {
        return this.buffer.position();
    }

    public ByteBufferReader unread(int length) {
        if (length > 0) {
            int pos = this.buffer.position() - length;
            this.buffer.position(Math.max(pos, 0));
        }
        return this;
    }

    public ByteBufferReader unreadAll() {
        return this.unread(this.hasRead());
    }

    public ByteBufferReader skip(int length) {
        if (length > 0) {
            int pos = this.buffer.position() + length;
            this.buffer.position(Math.min(pos, this.buffer.limit()));
        }
        return this;
    }

    public String dumpHex() {
        int size = this.readableBytes();
        if (size > 0) {
            return Hex.encodeHexString((byte[])this.readBytes(size));
        }
        return "";
    }

    public String dumpBase64() {
        int size = this.readableBytes();
        if (size > 0) {
            return Base64.getEncoder().encodeToString(this.readBytes(size));
        }
        return "";
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public static int findFirst(byte[] src, byte val) {
        int pos = 0;
        while (pos < src.length) {
            if (src[pos++] != val) continue;
            return pos;
        }
        return -1;
    }
}

