/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.io.buffer;

import com.power4j.coca.kit.common.io.buffer.BufferKit;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.springframework.lang.Nullable;

public class ByteBufferWriter {
    protected static final byte BYTE_ZERO = 0;
    protected ByteBuffer buffer;

    public static ByteBufferWriter of(ByteBuffer buffer, @Nullable ByteOrder order) {
        return new ByteBufferWriter(buffer, order);
    }

    public static ByteBufferWriter of(ByteBuffer buffer) {
        return new ByteBufferWriter(buffer, null);
    }

    public static ByteBufferWriter of(byte[] src, int offset, int length) {
        return new ByteBufferWriter(BufferKit.wrap(src, offset, length), null);
    }

    public static ByteBufferWriter of(byte[] src) {
        return new ByteBufferWriter(BufferKit.wrap(src, 0, src.length), null);
    }

    ByteBufferWriter(ByteBuffer buffer, @Nullable ByteOrder order) {
        this.buffer = buffer;
        if (Objects.nonNull(order)) {
            this.buffer.order(order);
        }
    }

    public ByteBufferWriter writeByte(int b) {
        this.buffer.put((byte)b);
        return this;
    }

    public ByteBufferWriter writeByteRepeat(int b, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count \u4e0d\u80fd\u5c0f\u4e8e0");
        }
        while (count-- > 0) {
            this.buffer.put((byte)b);
        }
        return this;
    }

    public ByteBufferWriter writeChar(int val) {
        this.buffer.putChar((char)val);
        return this;
    }

    public ByteBufferWriter writeBytes(byte[] src, int offset, int length) {
        this.buffer.put(src, offset, length);
        return this;
    }

    public ByteBufferWriter writeBytes(byte[] src) {
        this.buffer.put(src, 0, src.length);
        return this;
    }

    public ByteBufferWriter writeShort(int val) {
        this.buffer.putShort((short)val);
        return this;
    }

    public ByteBufferWriter writeInt(int val) {
        this.buffer.putInt(val);
        return this;
    }

    public ByteBufferWriter writeLong(long val) {
        this.buffer.putLong(val);
        return this;
    }

    public ByteBufferWriter writeFloat(float val) {
        this.buffer.putFloat(val);
        return this;
    }

    public ByteBufferWriter writeDouble(double val) {
        this.buffer.putDouble(val);
        return this;
    }

    public ByteBufferWriter writeString(String str, Charset charset, int length, byte filler) {
        byte[] raw = str.getBytes(charset);
        if (length < 0) {
            length = raw.length;
        }
        for (int i = 0; i < length; ++i) {
            if (i < raw.length) {
                this.buffer.put(raw[i]);
                continue;
            }
            this.buffer.put(filler);
        }
        return this;
    }

    public ByteBufferWriter writeFixedString(String str, int fixedSize) {
        return this.writeString(str, StandardCharsets.UTF_8, fixedSize, (byte)0);
    }

    public ByteBufferWriter discard(int length) {
        if (length > 0) {
            int result = Math.min(this.buffer.position(), length);
            this.buffer.position(this.buffer.position() - result);
        }
        return this;
    }

    public ByteBufferWriter discardAll() {
        return this.discard(this.hasWritten());
    }

    public ByteBufferWriter reserve(int length) {
        if (length > 0) {
            this.buffer.position(Math.min(this.buffer.position() + length, this.buffer.capacity()));
        }
        return this;
    }

    public int hasWritten() {
        return this.buffer.position();
    }

    public int writeableBytes() {
        return this.buffer.capacity() - this.buffer.position();
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public ByteBufferWriter order(ByteOrder order) {
        this.buffer.order(order);
        return this;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public byte peekAt(int pos) {
        return this.buffer.array()[pos];
    }

    public byte[] peekRange(int pos, int size) {
        return Arrays.copyOfRange(this.buffer.array(), pos, pos + size);
    }
}

