/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.io.buffer;

import com.power4j.coca.kit.common.io.buffer.ByteBufferReader;
import com.power4j.coca.kit.common.io.buffer.ByteBufferWriter;
import com.power4j.coca.kit.common.text.Display;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.springframework.lang.Nullable;

public class ByteData
implements Display {
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private byte[] buffer;
    private int writeIndex;

    protected ByteData(int capacity) {
        this(capacity == 0 ? EMPTY_BUFFER : new byte[capacity], 0);
    }

    protected ByteData(byte[] src, int offset, int length) {
        this(Arrays.copyOfRange(src, offset, offset + length), length);
    }

    protected ByteData(byte[] buffer, int writeIndex) {
        this.buffer = buffer;
        this.writeIndex = writeIndex;
    }

    public static ByteData shardOf(byte[] original) {
        return new ByteData(original, original.length);
    }

    public static ByteData ofCapacity(int capacity) {
        return new ByteData(capacity);
    }

    public static ByteData ofEmpty() {
        return ByteData.ofCapacity(0);
    }

    public static ByteData copyOf(byte[] original, int offset, int length) {
        return new ByteData(original, offset, length);
    }

    public static ByteData copyOf(byte[] original) {
        return ByteData.copyOf(original, 0, original.length);
    }

    public static ByteData copyOf(ByteData ... array) {
        ByteData data = ByteData.ofCapacity(128);
        for (ByteData src : array) {
            data.write(src);
        }
        return data;
    }

    public static ByteData copyOf(Iterator<ByteData> itr) {
        ByteData data = ByteData.ofCapacity(128);
        itr.forEachRemaining(data::write);
        return data;
    }

    public static ByteData ofRepeat(int val, int count) {
        ByteData byteData = ByteData.ofCapacity(count);
        Arrays.fill(byteData.buffer, 0, count, (byte)val);
        byteData.writeIndex(count);
        return byteData;
    }

    public static ByteData ofRandom(int size) {
        ByteData byteData = ByteData.ofCapacity(size);
        new Random().nextBytes(byteData.buffer);
        byteData.writeIndex(size);
        return byteData;
    }

    public static ByteData ofHex(String hexString) {
        try {
            byte[] bytes = Hex.decodeHex((String)hexString);
            return new ByteData(bytes, bytes.length);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("not hex string", e);
        }
    }

    public static ByteData ofBase64(String base64String) {
        byte[] bytes = Base64.getDecoder().decode(base64String);
        return new ByteData(bytes, bytes.length);
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int writeIndex() {
        return this.writeIndex;
    }

    public ByteData writeIndex(int value) {
        if (value > this.buffer.length || value < 0) {
            throw new IndexOutOfBoundsException("write index overflow");
        }
        this.writeIndex = value;
        return this;
    }

    public ByteData writeIndexAdvance(int distance) {
        this.writeIndex(this.writeIndex + distance);
        return this;
    }

    public ByteData writeIndexAdvanceSome(int max) {
        int value = this.writeIndex + max;
        if (value < 0) {
            value = 0;
        }
        if (value > this.buffer.length) {
            value = this.buffer.length;
        }
        this.writeIndex(value);
        return this;
    }

    public ByteData expandBy(int count) {
        int capacity = this.buffer.length;
        int newCapacity = capacity + count;
        if (newCapacity <= 0) {
            this.buffer = EMPTY_BUFFER;
            this.writeIndex = 0;
            return this;
        }
        if (newCapacity != capacity) {
            this.buffer = Arrays.copyOf(this.buffer, newCapacity);
            this.writeIndex = Math.min(this.writeIndex, newCapacity);
        }
        return this;
    }

    public ByteData expand() {
        this.expandBy(Math.max(1, this.buffer.length >> 1));
        return this;
    }

    public ByteData ensureWriteBytes(int size) {
        int more = size - this.writableBytes();
        if (more > 0) {
            this.expandBy(more);
        }
        return this;
    }

    public ByteData zeroMemory() {
        Arrays.fill(this.buffer, (byte)0);
        return this;
    }

    public int readableBytes() {
        return this.readableBytes(0);
    }

    public int readableBytes(int offset) {
        if (offset >= this.writeIndex) {
            return 0;
        }
        return this.writeIndex - offset;
    }

    public int writableBytes() {
        return this.buffer.length - this.writeIndex;
    }

    public byte readAt(int offset) {
        this.assertReadPos(offset);
        return this.buffer[offset];
    }

    public byte[] read(int offset, int count) {
        this.assertReadPos(offset);
        if (count < 0) {
            count = this.readableBytes(offset);
        }
        this.assertReadable(offset, count);
        return Arrays.copyOfRange(this.buffer, offset, offset + count);
    }

    public byte[] read(int count) {
        return this.read(0, count);
    }

    public byte[] readAll() {
        return this.read(0, this.readableBytes());
    }

    public byte[] readSome(int offset, int maxCount) {
        this.assertReadPos(offset);
        if (maxCount < 0) {
            throw new IllegalArgumentException("max count < 0");
        }
        return Arrays.copyOfRange(this.buffer, offset, Math.min(offset + maxCount, this.writeIndex));
    }

    public byte[] readSome(int maxCount) {
        return this.readSome(0, maxCount);
    }

    public String readString(int offset, int length, Charset charset) {
        this.assertReadPos(offset);
        if (length < 0) {
            length = this.readableBytes(offset);
        }
        this.assertReadable(offset, length);
        return new String(this.buffer, offset, length, charset);
    }

    public String readUtf8String(int offset, int length) {
        return this.readString(offset, length, StandardCharsets.UTF_8);
    }

    public String readHexLower(int offset, int length) {
        return Hex.encodeHexString((byte[])this.read(offset, length), (boolean)true);
    }

    public String readHexUpper(int offset, int length) {
        return Hex.encodeHexString((byte[])this.read(offset, length), (boolean)false);
    }

    public String readBase64(int offset, int length) {
        return Base64.getEncoder().encodeToString(this.read(offset, length));
    }

    public int readTo(int offset, byte[] dest, int destOffset, int length, int padding) {
        this.assertReadPos(offset);
        int readable = this.readableBytes(offset);
        for (int count = 0; count < length; ++count) {
            dest[destOffset + count] = count < readable ? this.buffer[offset + count] : (byte)padding;
        }
        return Math.max(0, length - readable);
    }

    public int readTo(int offset, byte[] dest, int padding) {
        return this.readTo(offset, dest, 0, dest.length, padding);
    }

    public ByteData write(ByteData src) {
        return this.writeBytes(src.buffer, 0, src.writeIndex);
    }

    public ByteData writeInt8(int b) {
        this.ensureWriteBytes(1);
        this.buffer[this.writeIndex++] = (byte)b;
        return this;
    }

    public ByteData writeInt16(int value, ByteOrder order) {
        int size = 2;
        this.ensureWriteBytes(2);
        this.bufferWriter(order).writeShort((short)value);
        this.writeIndexAdvance(2);
        return this;
    }

    public ByteData writeInt32(int value, ByteOrder order) {
        int size = 4;
        this.ensureWriteBytes(4);
        this.bufferWriter(order).writeInt(value);
        this.writeIndexAdvance(4);
        return this;
    }

    public ByteData writeInt64(long value, ByteOrder order) {
        int size = 8;
        this.ensureWriteBytes(8);
        this.bufferWriter(order).writeLong(value);
        this.writeIndexAdvance(8);
        return this;
    }

    public ByteData writeFloat(float value, ByteOrder order) {
        int size = 4;
        this.ensureWriteBytes(4);
        this.bufferWriter(order).writeFloat(value);
        this.writeIndexAdvance(4);
        return this;
    }

    public ByteData writeDouble(double value, ByteOrder order) {
        int size = 8;
        this.ensureWriteBytes(8);
        this.bufferWriter(order).writeDouble(value);
        this.writeIndexAdvance(8);
        return this;
    }

    public ByteData writeBytes(byte[] src, int offset, int length) {
        this.expandBy(length);
        for (int i = 0; i < length; ++i) {
            this.buffer[this.writeIndex++] = src[offset + i];
        }
        return this;
    }

    public ByteData writeBytes(byte[] src) {
        return this.writeBytes(src, 0, src.length);
    }

    public boolean dataEquals(ByteData that) {
        return this.dataEquals(that.read(-1));
    }

    public boolean dataEquals(@Nullable byte[] data) {
        return Arrays.equals(this.read(-1), data);
    }

    public ByteBufferWriter bufferWriter(ByteOrder order) {
        return ByteBufferWriter.of(ByteBuffer.wrap(this.buffer, this.writeIndex, this.writableBytes()), order);
    }

    public ByteBufferWriter bufferWriter() {
        return this.bufferWriter(ByteOrder.nativeOrder());
    }

    public ByteBufferReader bufferReader(ByteOrder order) {
        return ByteBufferReader.of(ByteBuffer.wrap(this.buffer, 0, this.readableBytes()), order);
    }

    public ByteBufferReader bufferReader() {
        return this.bufferReader(ByteOrder.nativeOrder());
    }

    public ByteData buffCopy(int offset, int length) {
        return ByteData.copyOf(this.buffer, offset, length);
    }

    public String toString() {
        return this.readHexLower(0, this.readableBytes());
    }

    @Override
    public String display() {
        return String.format("[%d]%s", this.readableBytes(), this.readHexLower(0, this.readableBytes()));
    }

    protected void assertReadPos(int pos) {
        if (pos < 0) {
            throw new IndexOutOfBoundsException("Index out of range: " + pos);
        }
    }

    protected void assertReadable(int pos, int length) {
        int endPos = pos + length;
        if (endPos > this.writeIndex) {
            throw new IndexOutOfBoundsException("Index out of range: " + endPos);
        }
    }
}

