/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.lang;

import com.power4j.coca.kit.common.lang.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.lang.Nullable;

public class ValueMapper<S, T> {
    private final Map<S, T> rules;

    public static <S, T> Builder<S, T> builder() {
        return new Builder();
    }

    ValueMapper(Map<S, T> rules) {
        this.rules = rules;
    }

    public T getValue(@Nullable S src, T defaultValue) {
        if (Objects.isNull(src)) {
            return defaultValue;
        }
        return this.rules.getOrDefault(src, defaultValue);
    }

    public static class Builder<S, T> {
        private final Map<S, T> ruleMap = new HashMap<S, T>();

        public Builder<S, T> rule(S src, T target) {
            this.ruleMap.put(src, target);
            return this;
        }

        public Builder<S, T> rules(Collection<Pair<S, T>> rules) {
            for (Pair<S, T> pair : rules) {
                this.ruleMap.put(Objects.requireNonNull(pair.getKey()), Objects.requireNonNull(pair.getValue()));
            }
            return this;
        }

        public ValueMapper<S, T> build() {
            return new ValueMapper<S, T>(this.ruleMap);
        }
    }
}

