/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.state;

import com.power4j.coca.kit.common.text.Display;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.springframework.lang.Nullable;

public final class State<T, E>
implements Display {
    @Nullable
    private final T value;
    @Nullable
    private final E error;

    public static <T, E> State<T, E> ok(@Nullable T data) {
        return new State<T, Object>(data, null);
    }

    public static <T, E> State<T, E> error(E err) {
        return new State<Object, E>(null, Objects.requireNonNull(err));
    }

    State(@Nullable T value, @Nullable E error) {
        this.value = value;
        this.error = error;
    }

    public boolean isError() {
        return this.error != null;
    }

    public boolean isErrorAnd(Predicate<? super E> predicate) {
        return this.isError() && predicate.test(this.error);
    }

    public boolean isOk() {
        return !this.isError();
    }

    public boolean isOkAnd(Predicate<? super T> predicate) {
        return this.isOk() && predicate.test(this.value);
    }

    @Nullable
    public T unwrap() {
        if (this.isError()) {
            throw new IllegalStateException("State is error");
        }
        return this.value;
    }

    public T unwrapNonNull() {
        T val = this.unwrap();
        if (val == null) {
            throw new NullPointerException("value is null");
        }
        return val;
    }

    @Nullable
    public T unwrapOr(T defVal) {
        if (this.isError()) {
            return defVal;
        }
        return this.value;
    }

    @Nullable
    public T unwrapOrElse(Supplier<T> supplier) {
        if (this.isError()) {
            return supplier.get();
        }
        return this.value;
    }

    public E unwrapError() {
        return this.tryUnwrapError().orElseThrow(() -> new IllegalStateException("not an error"));
    }

    public Optional<E> tryUnwrapError() {
        if (this.isError()) {
            return Optional.of(this.error);
        }
        return Optional.empty();
    }

    public <U> State<U, E> map(Function<? super T, ? extends U> func) {
        if (this.isOk()) {
            return State.ok(func.apply(this.value));
        }
        assert (this.error != null);
        return State.error(this.error);
    }

    public <F> State<T, F> mapError(Function<? super E, ? extends F> func) {
        if (this.isOk()) {
            return State.ok(this.value);
        }
        return State.error(func.apply(this.error));
    }

    @Nullable
    public <U> U mapOr(Function<? super T, ? extends U> func, U defVal) {
        if (this.isOk()) {
            return func.apply(this.value);
        }
        return defVal;
    }

    @Nullable
    public <U> U mapOrElse(Function<? super T, ? extends U> func, Supplier<? extends U> supplier) {
        if (this.isOk()) {
            return func.apply(this.value);
        }
        return supplier.get();
    }

    public <U> State<U, E> and(State<U, E> state) {
        if (this.isError()) {
            return State.error(this.error);
        }
        return state;
    }

    public <U> State<U, E> andThen(Function<? super T, ? extends State<U, E>> func) {
        if (this.isError()) {
            return State.error(this.error);
        }
        return func.apply(this.value);
    }

    public <F> State<T, F> or(State<T, F> state) {
        if (this.isError()) {
            return state;
        }
        return State.ok(this.value);
    }

    public <F> State<T, F> orElse(Function<? super E, ? extends State<T, F>> func) {
        if (this.isError()) {
            return func.apply(this.error);
        }
        return State.ok(this.value);
    }

    public static <T, E> State<T, E> flatten(State<? extends State<T, E>, E> state) {
        return state.andThen(Function.identity());
    }

    @Override
    public String display() {
        if (this.isOk()) {
            if (this.value == null) {
                return "Ok(null)";
            }
            if (this.value instanceof Optional && !((Optional)this.value).isPresent()) {
                return "Ok(wrapped null)";
            }
            return "Ok";
        }
        return "Error(" + this.error + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State state = (State)o;
        if (state.isError() && this.isError()) {
            return new EqualsBuilder().append(this.error, state.error).isEquals();
        }
        if (state.isOk() && this.isOk()) {
            return new EqualsBuilder().append(this.value, state.value).isEquals();
        }
        return false;
    }

    public int hashCode() {
        if (this.isError()) {
            return new HashCodeBuilder(17, 37).append(this.error).toHashCode();
        }
        return new HashCodeBuilder(17, 37).append(this.value).toHashCode();
    }
}

