/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.text.obscure;

import com.power4j.coca.kit.common.io.codec.Codec;
import com.power4j.coca.kit.common.io.codec.CodecException;
import com.power4j.coca.kit.common.io.codec.Decoder;
import com.power4j.coca.kit.common.io.codec.Encoder;
import com.power4j.coca.kit.common.io.codec.impl.Base64Codec;
import com.power4j.coca.kit.common.lang.Pair;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;

public class StrObscurer {
    static final String FLAG_SEPARATOR = ",";
    static final String BODY_SEPARATOR = " ";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private String flagPrefix = "+";
    private Codec<ByteBuffer, String> strCodec = new Base64Codec();
    private Map<String, Codec<ByteBuffer, ByteBuffer>> codecRegistry = Collections.emptyMap();

    public static StrObscurer ofEncoders(List<Codec<ByteBuffer, ByteBuffer>> codecs) {
        StrObscurer obscurer = new StrObscurer();
        obscurer.setCodecList(codecs);
        return obscurer;
    }

    public String obscure(String str, EncoderSelector selector) throws CodecException {
        List<Encoder<ByteBuffer, ByteBuffer>> encoders = selector.select(str, new ArrayList<Encoder<ByteBuffer, ByteBuffer>>(this.codecRegistry.values()));
        ByteBuffer buffer = ByteBuffer.wrap(str.getBytes(CHARSET));
        for (Encoder<ByteBuffer, ByteBuffer> encoder : encoders) {
            buffer = encoder.encode(buffer);
        }
        return this.buildHeader(encoders) + (String)this.strCodec.encode(buffer);
    }

    public String obscure(String str) throws CodecException {
        return this.obscure(str, EncoderSelector.ALL);
    }

    public String parse(String str) throws CodecException {
        Pair<List<String>, String> flagAndBody = this.parseFlagAndBody(str);
        List<String> flags = Objects.requireNonNull(flagAndBody.getKey());
        ByteBuffer raw = (ByteBuffer)this.strCodec.decode((ByteBuffer)((Object)flagAndBody.getValue()));
        if (!flags.isEmpty()) {
            raw = this.restoreData(flags, raw);
        }
        return new String(raw.array(), CHARSET);
    }

    public void setStrCodec(Codec<ByteBuffer, String> strCodec) {
        this.strCodec = strCodec;
    }

    public void setFlagPrefix(String flagPrefix) {
        this.flagPrefix = flagPrefix;
    }

    public void setCodecList(List<Codec<ByteBuffer, ByteBuffer>> codecs) {
        TreeMap<String, Codec<ByteBuffer, ByteBuffer>> map = new TreeMap<String, Codec<ByteBuffer, ByteBuffer>>();
        codecs.forEach(o -> map.put(o.name(), (Codec<ByteBuffer, ByteBuffer>)o));
        this.codecRegistry = map;
    }

    protected ByteBuffer restoreData(List<String> flags, ByteBuffer buffer) throws CodecException {
        flags = new ArrayList<String>(flags);
        Collections.reverse(flags);
        for (String name : flags) {
            Decoder decoder = this.codecRegistry.get(name);
            if (Objects.isNull(decoder)) {
                throw new CodecException("Missing decoder :" + name);
            }
            buffer = (ByteBuffer)decoder.decode(buffer);
        }
        return buffer;
    }

    String encodeFlag(Encoder<?, ?> encoder) {
        return this.flagPrefix + encoder.name();
    }

    String extractFlag(String value) {
        return StringUtils.removeStart((String)value, (String)this.flagPrefix);
    }

    String buildHeader(@Nullable List<? extends Encoder<?, ?>> encoders) {
        if (Objects.isNull(encoders) || encoders.isEmpty()) {
            return "";
        }
        String header = encoders.stream().map(this::encodeFlag).collect(Collectors.joining(FLAG_SEPARATOR));
        return header + BODY_SEPARATOR;
    }

    Pair<List<String>, String> parseFlagAndBody(String input) {
        int piece = 2;
        String[] flagAndBody = StringUtils.split((String)input, (String)BODY_SEPARATOR, (int)2);
        if (flagAndBody.length >= 2) {
            List flags = Stream.of(StringUtils.split((String)flagAndBody[0], (String)FLAG_SEPARATOR)).map(this::extractFlag).collect(Collectors.toList());
            return Pair.of(flags, flagAndBody[1]);
        }
        return Pair.of(Collections.emptyList(), flagAndBody[0]);
    }

    public static interface EncoderSelector {
        public static final EncoderSelector ALL = (s, list) -> list;

        public List<Encoder<ByteBuffer, ByteBuffer>> select(String var1, List<Encoder<ByteBuffer, ByteBuffer>> var2);
    }
}

