/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.coca.kit.common.util.exception;

import com.power4j.coca.kit.common.util.function.RunAny;
import com.power4j.coca.kit.common.util.function.SupplyAny;
import java.util.Objects;
import org.springframework.lang.Nullable;

public class NoThrow {
    public static State<Void> run(RunAny anyRun) {
        try {
            anyRun.run();
            return State.offer(null);
        }
        catch (Throwable e) {
            return State.exceptionally(e);
        }
    }

    public static <T> State<T> apply(SupplyAny<T> anySup) {
        try {
            return State.offer(anySup.get());
        }
        catch (Throwable e) {
            return State.exceptionally(e);
        }
    }

    public static class State<T> {
        @Nullable
        private final T object;
        @Nullable
        private final Throwable exception;

        private static <T> State<T> exceptionally(Throwable e) {
            return new State<Object>(null, e);
        }

        private static <T> State<T> offer(T object) {
            return new State<T>(object, null);
        }

        State(@Nullable T object, @Nullable Throwable exception) {
            this.object = object;
            this.exception = exception;
        }

        @Nullable
        public T getObject() {
            return this.object;
        }

        @Nullable
        public Throwable getException() {
            return this.exception;
        }

        @Nullable
        public <E extends Throwable> E getCastedException() {
            return (E)this.exception;
        }

        public boolean isError() {
            return Objects.nonNull(this.exception);
        }
    }
}

