/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.kit.common.data.dict.config;

import cn.hutool.core.util.StrUtil;
import com.power4j.kit.common.data.dict.annotation.MapDict;
import com.power4j.kit.common.data.dict.config.DictMapperProperties;
import com.power4j.kit.common.data.dict.config.DictScannerConfigurer;
import com.power4j.kit.common.data.dict.support.RestResponseProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={DictMapperProperties.class})
@Import(value={DictMapperScannerRegistrar.class})
public class DictMapperAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(DictMapperAutoConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public RestResponseProcessor<?> restResponseProcessor() {
        return data -> {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("code", 0);
            map.put("msg", "ok");
            map.put("data", data);
            return map;
        };
    }

    public static class DictMapperScannerRegistrar
    implements EnvironmentAware,
    BeanFactoryAware,
    ImportBeanDefinitionRegistrar {
        @Nullable
        private BeanFactory beanFactory;
        @Nullable
        private Environment environment;

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (!AutoConfigurationPackages.has((BeanFactory)this.beanFactory)) {
                log.debug("Could not determine auto-configuration package, automatic mapper scanning disabled.");
                return;
            }
            log.debug("Searching for @Dict");
            List packages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
            String[] scanPackages = (String[])this.environment.getProperty("dict-mapper.scan-packages", String[].class, (Object)new String[0]);
            packages.addAll(Arrays.asList(scanPackages).stream().flatMap(o -> StrUtil.splitTrim((CharSequence)o, (CharSequence)",").stream()).collect(Collectors.toList()));
            if (log.isDebugEnabled()) {
                packages.forEach(pkg -> log.debug("Using auto-configuration base package '{}'", pkg));
            }
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(DictScannerConfigurer.class);
            builder.addPropertyValue("annotationClass", MapDict.class);
            builder.addPropertyValue("basePackage", (Object)StringUtils.collectionToCommaDelimitedString((Collection)packages));
            registry.registerBeanDefinition(DictScannerConfigurer.class.getName(), (BeanDefinition)builder.getBeanDefinition());
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }
    }
}

