/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.kit.common.data.dict.config;

import com.power4j.kit.common.data.dict.annotation.MapDict;
import com.power4j.kit.common.data.dict.config.DictRepositoryCustomizer;
import com.power4j.kit.common.data.dict.model.Dict;
import com.power4j.kit.common.data.dict.repository.DictRepository;
import com.power4j.kit.common.data.dict.support.DefaultDictResolver;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DictScannerConfigurer
implements ApplicationContextAware,
BeanPostProcessor,
BeanDefinitionRegistryPostProcessor,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DictScannerConfigurer.class);
    private String basePackage;
    private Class<? extends Annotation> annotationClass;
    @Nullable
    private ApplicationContext applicationContext;

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.basePackage, (String)"Property 'basePackage' is required");
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        DictEnumClassPathScanningCandidateComponentProvider provider = new DictEnumClassPathScanningCandidateComponentProvider();
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(this.annotationClass));
        HashSet beanDefinitionSet = new HashSet(8);
        StringUtils.commaDelimitedListToSet((String)this.basePackage).forEach(pkg -> beanDefinitionSet.addAll(provider.findCandidateComponents((String)pkg)));
        HashMap dictMap = new HashMap(beanDefinitionSet.size());
        DefaultDictResolver dictResolver = new DefaultDictResolver();
        beanDefinitionSet.forEach(bds -> {
            try {
                Class<Enum<?>> enumClass = Class.forName(bds.getBeanClassName());
                Dict dict = dictResolver.resolve(enumClass).orElse(null);
                if (dict != null) {
                    if (dictMap.containsKey(dict.getCode())) {
                        log.warn("Duplicate dict code '{}' found on {}", (Object)dict.getCode(), (Object)enumClass.getName());
                    }
                    dictMap.put(dict.getCode(), dict);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(DictRepository.class);
        builder.addPropertyValue("dictMap", dictMap);
        registry.registerBeanDefinition(DictRepository.class.getSimpleName(), (BeanDefinition)builder.getBeanDefinition());
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Nullable
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DictRepository) {
            ObjectProvider customizers = this.applicationContext.getBeanProvider(DictRepositoryCustomizer.class);
            customizers.stream().forEachOrdered(o -> o.customize((DictRepository)bean));
        }
        return bean;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    private static class DictEnumClassPathScanningCandidateComponentProvider
    extends ClassPathScanningCandidateComponentProvider {
        DictEnumClassPathScanningCandidateComponentProvider() {
            super(false);
            this.addIncludeFilter(new IsEnumFilter());
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(MapDict.class));
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return beanDefinition.getMetadata().isIndependent();
        }

        private static class IsEnumFilter
        implements TypeFilter {
            private IsEnumFilter() {
            }

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                String className = metadataReader.getClassMetadata().getClassName();
                Class<?> clazz = Class.forName(className);
                return clazz.isEnum();
            }
        }
    }
}

