/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.kit.common.data.dict.support;

import cn.hutool.core.util.StrUtil;
import com.power4j.kit.common.data.dict.annotation.DictValue;
import com.power4j.kit.common.data.dict.annotation.Item;
import com.power4j.kit.common.data.dict.annotation.MapDict;
import com.power4j.kit.common.data.dict.model.Dict;
import com.power4j.kit.common.data.dict.model.DictItem;
import com.power4j.kit.common.data.dict.support.DictResolver;
import com.power4j.kit.common.data.dict.support.ItemResolverHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.core.annotation.AnnotationUtils;

public class DefaultDictResolver
implements DictResolver {
    static final String ITEM_DEFAULT_STYLE = "";
    static final String ITEM_DEFAULT_REMARKS = "";

    @Override
    public Optional<Dict> resolve(Class<Enum<?>> enumClass) {
        MapDict annotation = (MapDict)AnnotationUtils.findAnnotation(enumClass, MapDict.class);
        if (annotation == null) {
            return Optional.empty();
        }
        Dict dict = new Dict();
        dict.setCode(this.lookupDictCode(annotation, enumClass.getSimpleName()));
        dict.setName(this.lookupDictName(annotation, dict.getCode()));
        dict.setRemarks(this.lookupDictRemarks(annotation, ""));
        if (StrUtil.isBlank((CharSequence)dict.getCode())) {
            dict.setCode(enumClass.getSimpleName());
        }
        if (StrUtil.isBlank((CharSequence)dict.getName())) {
            dict.setCode(dict.getCode());
        }
        dict.setItems(this.lookupDictItems(annotation, enumClass));
        return Optional.of(dict);
    }

    protected DictItem createDictItem(Item item) {
        return ItemResolverHelper.createDictItem(item.value(), item.label(), item.style(), item.remarks(), null);
    }

    protected String lookupDictCode(MapDict annotation, String defVal) {
        return StrUtil.isEmpty((CharSequence)annotation.code()) ? defVal : annotation.code();
    }

    protected String lookupDictName(MapDict annotation, String defVal) {
        return StrUtil.isEmpty((CharSequence)annotation.name()) ? defVal : annotation.name();
    }

    protected String lookupDictRemarks(MapDict annotation, String defVal) {
        return StrUtil.isEmpty((CharSequence)annotation.remarks()) ? defVal : annotation.remarks();
    }

    protected List<DictItem> getDictItems(MapDict annotation) {
        return Arrays.stream(annotation.items()).map(o -> this.createDictItem((Item)o)).collect(Collectors.toList());
    }

    protected List<DictItem> lookupDictItems(MapDict annotation, Class<Enum<?>> enumClass) {
        List<DictItem> itemList = this.getDictItems(annotation);
        if (!itemList.isEmpty()) {
            return itemList;
        }
        ItemResolverHelper helper = new ItemResolverHelper(enumClass, "", "").lookup();
        if (!helper.getValueFunc().isPresent()) {
            throw new IllegalStateException(String.format("Could not resolve value for dict item for %s,use %s or %s", enumClass.getName(), DictValue.class.getSimpleName(), Item.class.getSimpleName()));
        }
        return helper.buildItemList();
    }
}

