/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.kit.common.data.dict.support;

import cn.hutool.core.collection.CollectionUtil;
import com.power4j.kit.common.data.dict.model.Dict;
import com.power4j.kit.common.data.dict.repository.DictRepository;
import com.power4j.kit.common.data.dict.support.DictConverter;
import com.power4j.kit.common.data.dict.support.DictItemConverter;
import com.power4j.kit.common.data.dict.support.RestResponseProcessor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5e38\u91cf\u5b57\u5178")
@RestController
@RequestMapping(value={"${ji-boot.dict.endpoint-base-url:/sys/immutable-dictionaries}"})
@ConditionalOnProperty(prefix="dict-mapper", name={"enable-endpoint"}, havingValue="true", matchIfMissing=true)
public class DictEndpoint {
    private final DictRepository dictRepository;
    private final ObjectProvider<RestResponseProcessor<?>> restResponseProcessors;
    private final ObjectProvider<DictConverter<?>> dictConverters;
    private final ObjectProvider<DictItemConverter<?>> dictItemConverters;
    private final AtomicReference<List<Dict>> dictList = new AtomicReference();

    @GetMapping(value={"/page"})
    @Operation(summary="\u5206\u9875")
    public ResponseEntity<?> getDictList(@RequestParam(name="current", required=false) Integer page, @RequestParam(name="limit", required=false) Integer size) {
        List data = this.dictList.updateAndGet(o -> o == null ? this.makeDictList() : o);
        if (page == null || page < 1) {
            page = 1;
        }
        if (size == null || size < 1) {
            size = 20;
        }
        int start = (page - 1) * size;
        data = CollectionUtil.sub(data, (int)start, (int)(start + size));
        DictConverter converter = (DictConverter)this.dictConverters.getIfAvailable();
        List converted = data;
        if (converter != null) {
            converted = data.stream().map(converter::convert).collect(Collectors.toList());
        }
        return ResponseEntity.ok(((RestResponseProcessor)this.restResponseProcessors.getIfAvailable(() -> RestResponseProcessor.AS_IS)).process(converted));
    }

    @GetMapping(value={"/code/{code}"})
    @Operation(summary="\u5b57\u5178\u9879\u5217\u8868")
    public ResponseEntity<?> listItems(@PathVariable(value="code") String code) {
        List data = this.dictRepository.get(code).map(Dict::getItems).orElse(Collections.emptyList());
        DictItemConverter converter = (DictItemConverter)this.dictItemConverters.getIfAvailable();
        List converted = data;
        if (converter != null) {
            converted = data.stream().map(converter::convert).collect(Collectors.toList());
        }
        return ResponseEntity.ok(((RestResponseProcessor)this.restResponseProcessors.getIfAvailable(() -> RestResponseProcessor.AS_IS)).process(converted));
    }

    protected List<Dict> makeDictList() {
        if (this.dictRepository.getDictMap() != null) {
            return this.dictRepository.getDictMap().values().stream().sorted(Comparator.comparing(Dict::getCode)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public DictEndpoint(DictRepository dictRepository, ObjectProvider<RestResponseProcessor<?>> restResponseProcessors, ObjectProvider<DictConverter<?>> dictConverters, ObjectProvider<DictItemConverter<?>> dictItemConverters) {
        this.dictRepository = dictRepository;
        this.restResponseProcessors = restResponseProcessors;
        this.dictConverters = dictConverters;
        this.dictItemConverters = dictItemConverters;
    }
}

