/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.kit.common.data.dict.support;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.power4j.kit.common.data.dict.annotation.DictValue;
import com.power4j.kit.common.data.dict.annotation.Label;
import com.power4j.kit.common.data.dict.annotation.Remarks;
import com.power4j.kit.common.data.dict.annotation.Styled;
import com.power4j.kit.common.data.dict.model.DictItem;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class ItemResolverHelper {
    private static final Logger log = LoggerFactory.getLogger(ItemResolverHelper.class);
    private final MultiValueMap<Class<? extends Annotation>, Field> fieldMap = new LinkedMultiValueMap(8);
    private final Map<Class<? extends Annotation>, Method> methodMap = new HashMap<Class<? extends Annotation>, Method>(8);
    private final Class<Enum<?>> enumClass;
    private final Map<Object, Object> labelMap = new HashMap<Object, Object>(8);
    private final Map<Object, Object> styleMap = new HashMap<Object, Object>(8);
    private final Map<Object, Object> remarksMap = new HashMap<Object, Object>(8);
    @Nullable
    private Function<Enum<?>, Object> labelFunc;
    @Nullable
    private Function<Enum<?>, Object> valueFunc;
    @Nullable
    private Function<Enum<?>, Object> styleFunc;
    @Nullable
    private Function<Enum<?>, Object> remarksFunc;
    @Nullable
    private String defaultStyle;
    @Nullable
    private String defaultRemarks;

    public static DictItem createDictItem(String value, @Nullable String label, @Nullable String style, @Nullable String remarks, @Nullable Map<String, Object> extra) {
        DictItem dictItem = new DictItem();
        dictItem.setValue(value);
        dictItem.setLabel(label);
        dictItem.setStyle(style);
        dictItem.setRemarks(remarks);
        dictItem.setExtra(extra == null ? Collections.emptyMap() : extra);
        return dictItem;
    }

    public ItemResolverHelper(Class<Enum<?>> enumClass) {
        this.enumClass = enumClass;
    }

    public ItemResolverHelper(Class<Enum<?>> enumClass, String defaultStyle, String defaultRemarks) {
        this.enumClass = enumClass;
        this.defaultStyle = defaultStyle;
        this.defaultRemarks = defaultRemarks;
    }

    public Optional<Function<Enum<?>, Object>> getLabelFunc() {
        return Optional.ofNullable(this.labelFunc);
    }

    public Optional<Function<Enum<?>, Object>> getValueFunc() {
        return Optional.ofNullable(this.valueFunc);
    }

    public Optional<Function<Enum<?>, Object>> getStyleFunc() {
        return Optional.ofNullable(this.styleFunc);
    }

    public Optional<Function<Enum<?>, Object>> getRemarksFunc() {
        return Optional.ofNullable(this.remarksFunc);
    }

    public boolean fullFilled() {
        return this.labelFunc != null && this.valueFunc != null && this.styleFunc != null && this.remarksFunc != null;
    }

    public ItemResolverHelper lookup() {
        this.scanAnnotationMethods(this.enumClass);
        this.scanAnnotationFields(this.enumClass);
        if (!this.processFields()) {
            this.processMethods();
        }
        return this;
    }

    public List<DictItem> buildItemList() {
        ArrayList<DictItem> itemList = new ArrayList<DictItem>(4);
        Enum<?>[] enumArray = this.enumClass.getEnumConstants();
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            Enum<?> object;
            Enum<?> em = object = enumArray[i];
            String value = this.getValueFunc().map(f -> f.apply(em)).map(Object::toString).orElseThrow(() -> new IllegalStateException("No value for " + this.enumClass.getName()));
            String label = this.getLabelFunc().map(f -> f.apply(em)).map(Object::toString).orElse(value);
            String style = this.getStyleFunc().map(f -> f.apply(em)).map(Object::toString).orElse(this.defaultStyle);
            String remarks = this.getRemarksFunc().map(f -> f.apply(em)).map(Object::toString).orElse(this.defaultRemarks);
            itemList.add(ItemResolverHelper.createDictItem(value, label, style, remarks, null));
        }
        return itemList;
    }

    protected boolean processFields() {
        if (this.valueFunc == null) {
            this.valueFunc = this.fieldMap.containsKey(DictValue.class) ? o -> this.filedGet(o, (Field)this.fieldMap.getFirst(DictValue.class)) : Enum::ordinal;
        }
        return this.fullFilled();
    }

    protected boolean processMethods() {
        if (this.valueFunc == null && this.methodMap.containsKey(DictValue.class)) {
            this.valueFunc = o -> this.methodGet(o, this.methodMap.get(DictValue.class));
        }
        if (this.labelFunc == null && this.methodMap.containsKey(Label.class)) {
            this.labelFunc = o -> this.methodGet(o, this.methodMap.get(Label.class));
        }
        if (this.styleFunc == null && this.methodMap.containsKey(Styled.class)) {
            this.styleFunc = o -> this.methodGet(o, this.methodMap.get(Styled.class));
        }
        if (this.remarksFunc == null && this.methodMap.containsKey(Remarks.class)) {
            this.remarksFunc = o -> this.methodGet(o, this.methodMap.get(Remarks.class));
        }
        return this.fullFilled();
    }

    protected final String makeEnumConstantKey(Class<Enum<?>> enumClass, Field field) {
        return enumClass.getName() + "." + field.getName();
    }

    protected final String makeEnumConstantKey(Enum<?> em) {
        return em.getClass().getName() + "." + em.name();
    }

    protected void scanAnnotationFields(Class<Enum<?>> enumClass) {
        Field[] fields;
        for (Field field : fields = ClassUtil.getDeclaredFields(enumClass)) {
            boolean enumConstant = field.isEnumConstant();
            if (field.isAnnotationPresent(DictValue.class)) {
                if (enumConstant) {
                    log.warn("@{} on enum constant is not allowed", (Object)DictValue.class.getSimpleName());
                } else {
                    this.fieldMap.add(DictValue.class, (Object)field);
                }
            }
            if (field.isAnnotationPresent(Label.class)) {
                if (!enumConstant) {
                    log.warn("@{} should annotation on enum constant field", (Object)Label.class.getSimpleName());
                } else {
                    Label label = field.getAnnotation(Label.class);
                    if (StrUtil.isNotEmpty((CharSequence)label.value())) {
                        this.labelMap.put(this.makeEnumConstantKey(enumClass, field), label.value());
                    }
                    this.labelFunc = o -> this.labelMap.get(this.makeEnumConstantKey((Enum<?>)o));
                }
            }
            if (field.isAnnotationPresent(Styled.class)) {
                if (!enumConstant) {
                    log.warn("@{} should annotation on enum constant field", (Object)Styled.class.getSimpleName());
                } else {
                    Styled styled = field.getAnnotation(Styled.class);
                    if (StrUtil.isNotEmpty((CharSequence)styled.value())) {
                        this.styleMap.put(this.makeEnumConstantKey(enumClass, field), styled.value());
                    }
                    this.styleFunc = o -> this.styleMap.get(this.makeEnumConstantKey((Enum<?>)o));
                }
            }
            if (!field.isAnnotationPresent(Remarks.class)) continue;
            if (!enumConstant) {
                log.warn("@{} should annotation on enum constant field", (Object)Remarks.class.getSimpleName());
                continue;
            }
            Remarks remarks = field.getAnnotation(Remarks.class);
            if (StrUtil.isNotEmpty((CharSequence)remarks.value())) {
                this.remarksMap.put(this.makeEnumConstantKey(enumClass, field), remarks.value());
            }
            this.remarksFunc = o -> this.remarksMap.get(this.makeEnumConstantKey((Enum<?>)o));
        }
    }

    protected void scanAnnotationMethods(Class<Enum<?>> enumClass) {
        Method[] methods;
        for (Method method : methods = ReflectUtil.getPublicMethods(enumClass)) {
            if (method.isAnnotationPresent(DictValue.class)) {
                this.methodMap.put(DictValue.class, method);
            }
            if (method.isAnnotationPresent(Label.class)) {
                this.methodMap.put(Label.class, method);
            }
            if (!method.isAnnotationPresent(Styled.class)) continue;
            this.methodMap.put(Styled.class, method);
        }
    }

    protected Object filedGet(Object instance, Field field) {
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected Object methodGet(Object instance, Method method) {
        try {
            return method.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

