/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.error;

import com.power4j.tile.error.Err;
import com.power4j.tile.fmt.Display;
import java.util.Objects;
import java.util.Optional;
import org.springframework.lang.Nullable;

public class ErrValue<T>
implements Err {
    protected final T value;
    protected final String message;
    @Nullable
    protected final Err source;

    public ErrValue(T value, @Nullable String message, @Nullable Err source) {
        this.value = Objects.requireNonNull(value);
        this.message = message == null ? "" : message;
        this.source = source;
    }

    public ErrValue(T value, @Nullable String message) {
        this(value, message, null);
    }

    public T value() {
        return this.value;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public Optional<Err> source() {
        return Optional.ofNullable(this.source);
    }

    @Override
    public String display() {
        if (this.value instanceof Display) {
            return String.format("[%s] - %s", ((Display)this.value).display(), this.message);
        }
        return String.format("[%s] - %s", this.value, this.message);
    }
}

