/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.ffi;

import com.power4j.tile.error.Err;
import com.power4j.tile.error.ErrValue;
import com.power4j.tile.ffi.InvalidCStrBytesException;
import com.power4j.tile.fmt.Display;
import com.power4j.tile.result.Result;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class CStr {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final byte[] bytes;
    public static final CStr EMPTY = new CStr(new byte[1]);

    CStr(byte[] bytes) {
        this.bytes = bytes;
    }

    public static CStr refOf(byte[] bytes) {
        return new CStr(bytes);
    }

    public static CStr copyOf(byte[] bytes, int offset, int length) {
        byte[] copy = Arrays.copyOfRange(bytes, offset, offset + length);
        return new CStr(copy);
    }

    public static CStr makeBuffer(String str) {
        if (str.isEmpty()) {
            return EMPTY;
        }
        byte[] all = str.getBytes(UTF8);
        return CStr.refOf(Arrays.copyOf(all, all.length + 1));
    }

    public static CStr makeBuffer(String str, int length) {
        if (str.isEmpty()) {
            return EMPTY;
        }
        byte[] all = str.getBytes(UTF8);
        if (all.length == length) {
            all[length - 1] = 0;
            return CStr.refOf(all);
        }
        if (all.length < length) {
            byte[] bytes = new byte[length];
            System.arraycopy(all, 0, bytes, 0, all.length);
            Arrays.fill(bytes, all.length, length, (byte)0);
            return CStr.refOf(bytes);
        }
        all[length - 1] = 0;
        return CStr.copyOf(all, 0, length);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public Result<String, Err> tryReadUntilNull(int offset, int length) {
        if (length == -1) {
            length = this.bytes.length - offset;
        }
        for (int i = 0; i < length; ++i) {
            if (this.bytes[offset + i] != 0) continue;
            String str = new String(this.bytes, offset, i, UTF8);
            return Result.ok(str);
        }
        NotNulTerminated reason = new NotNulTerminated(offset, length);
        return Result.error(new ErrValue<NotNulTerminated>(reason, reason.getMessage()));
    }

    public String readUntilNull(int offset, int length) {
        return this.tryReadUntilNull(offset, length).unwrapOrThrow(e -> new InvalidCStrBytesException(e.message()));
    }

    public Result<String, Err> tryReadWithNullCheck(int offset, int length) {
        int index;
        if (length == -1) {
            length = this.bytes.length - offset;
        }
        if ((index = this.indexOf(offset, length, (byte)0)) == -1) {
            NotNulTerminated reason = new NotNulTerminated(offset, length);
            return Result.error(new ErrValue<NotNulTerminated>(reason, reason.getMessage()));
        }
        if (index != length - 1) {
            InteriorNul reason = new InteriorNul(offset, index);
            return Result.error(new ErrValue<InteriorNul>(reason, reason.getMessage()));
        }
        return Result.ok(new String(this.bytes, offset, length - 1, UTF8));
    }

    public String readWithNullCheck(int offset, int length) {
        return this.tryReadWithNullCheck(offset, length).unwrapOrThrow(e -> new InvalidCStrBytesException(e.message()));
    }

    public String readUntilEnd(int offset, int length) {
        if (length == -1) {
            length = this.bytes.length - offset;
        }
        for (int i = 0; i < length; ++i) {
            if (this.bytes[offset + i] != 0) continue;
            return new String(this.bytes, offset, i, UTF8);
        }
        return new String(this.bytes, offset, length, UTF8);
    }

    protected int indexOf(int offset, int length, byte b) {
        int pos = -1;
        for (int i = 0; i < length; ++i) {
            if (b != this.bytes[offset + i]) continue;
            pos = i;
            break;
        }
        return pos;
    }

    public static class NotNulTerminated
    implements Display {
        private final int offset;
        private final int length;

        public NotNulTerminated(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String getMessage() {
            return "Data is not nul terminated at pos " + (this.length + this.offset) + " with offset " + this.offset;
        }

        @Override
        public String display() {
            return this.getClass().getSimpleName();
        }
    }

    public static class InteriorNul
    implements Display {
        private final int offset;
        private final int pos;

        public InteriorNul(int offset, int pos) {
            this.offset = offset;
            this.pos = pos;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getPos() {
            return this.pos;
        }

        public String getMessage() {
            return "Contains an interior nul byte at pos " + this.pos + " with offset " + this.offset;
        }

        @Override
        public String display() {
            return this.getClass().getSimpleName();
        }
    }
}

