/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.result;

import com.power4j.tile.fmt.Display;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;

public class Result<T, E>
implements Display {
    private static final Result<?, ?> EMPTY = new Result<Object, Object>(new Object(), null);
    @Nullable
    private final T value;
    @Nullable
    private final E error;

    public static <T, E> Result<T, E> ok(T value) {
        return new Result<T, Object>(Objects.requireNonNull(value), null);
    }

    public static <T, E> Result<Optional<T>, E> some(@Nullable T value) {
        return new Result<Optional<T>, Object>(Optional.ofNullable(value), null);
    }

    public static <E> Result<?, E> none() {
        return EMPTY;
    }

    public static <T, E> Result<T, E> error(E err) {
        return new Result<Object, E>(null, Objects.requireNonNull(err));
    }

    Result(@Nullable T value, @Nullable E error) {
        this.value = value;
        this.error = error;
    }

    public Result<T, E> copy() {
        return new Result<T, E>(this.value, this.error);
    }

    public boolean isError() {
        return this.error != null;
    }

    public boolean isErrorAnd(Predicate<? super E> predicate) {
        return this.isError() && predicate.test(this.error);
    }

    public boolean isOk() {
        return !this.isError();
    }

    public boolean isOkAnd(Predicate<? super T> predicate) {
        return this.isOk() && predicate.test(this.value);
    }

    public T unwrap() {
        if (this.isError()) {
            assert (this.error != null);
            String info = this.error instanceof Display ? ((Display)this.error).display() : this.error.toString();
            throw new IllegalStateException("Result is error:" + info);
        }
        assert (this.value != null);
        return this.value;
    }

    public T unwrapOrThrow(Function<? super E, ? extends RuntimeException> func) {
        if (this.isError()) {
            assert (this.error != null);
            throw func.apply(this.error);
        }
        assert (this.value != null);
        return this.value;
    }

    public T unwrapOr(T defVal) {
        if (this.isError()) {
            return Objects.requireNonNull(defVal);
        }
        assert (this.value != null);
        return this.value;
    }

    public T unwrapOrElse(Supplier<T> supplier) {
        if (this.isError()) {
            return Objects.requireNonNull(supplier.get());
        }
        assert (this.value != null);
        return this.value;
    }

    public E unwrapError() {
        return this.tryUnwrapError().orElseThrow(() -> new IllegalStateException("not an error"));
    }

    public <F> F unwrapError(Class<F> clazz) {
        E err = this.unwrapError();
        return clazz.cast(err);
    }

    public Optional<E> tryUnwrapError() {
        if (this.isError()) {
            assert (this.error != null);
            return Optional.of(this.error);
        }
        return Optional.empty();
    }

    public <U> Result<U, E> map(Function<? super T, ? extends U> func) {
        if (this.isOk()) {
            return Result.ok(func.apply(this.value));
        }
        assert (this.error != null);
        return Result.error(this.error);
    }

    public <F> Result<T, F> mapError(Function<? super E, ? extends F> func) {
        if (this.isOk()) {
            assert (this.value != null);
            return Result.ok(this.value);
        }
        return Result.error(func.apply(this.error));
    }

    public <U> U mapOr(Function<? super T, ? extends U> func, U defVal) {
        if (this.isOk()) {
            return Objects.requireNonNull(func.apply(this.value));
        }
        return Objects.requireNonNull(defVal);
    }

    public <U> U mapOrElse(Function<? super T, ? extends U> func, Supplier<? extends U> supplier) {
        if (this.isOk()) {
            return Objects.requireNonNull(func.apply(this.value));
        }
        return Objects.requireNonNull(supplier.get());
    }

    public <U> Result<U, E> and(Result<U, E> other) {
        if (this.isError()) {
            assert (this.error != null);
            return Result.error(this.error);
        }
        return other;
    }

    public <U> Result<U, E> andThen(Function<? super T, ? extends Result<U, E>> func) {
        if (this.isError()) {
            assert (this.error != null);
            return Result.error(this.error);
        }
        return func.apply(this.value);
    }

    public <F> Result<T, F> or(Result<T, F> other) {
        if (this.isError()) {
            return other;
        }
        assert (this.value != null);
        return Result.ok(this.value);
    }

    public <F> Result<T, F> orElse(Function<? super E, ? extends Result<T, F>> func) {
        if (this.isError()) {
            return func.apply(this.error);
        }
        assert (this.value != null);
        return Result.ok(this.value);
    }

    public static <T, E> Result<T, E> flatten(Result<? extends Result<T, E>, E> result) {
        return result.andThen(Function.identity());
    }

    @Override
    public String display() {
        if (this.isOk()) {
            if (this.value instanceof Optional && !((Optional)this.value).isPresent()) {
                return "Ok(empty)";
            }
            return "Ok";
        }
        return "Error(" + this.error + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        return Objects.equals(this.value, result.value) && Objects.equals(this.error, result.error);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.error);
    }
}

