/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.agreement.sm2;

import com.power4j.tile.crypto.agreement.sm2.ExchangeContext;
import com.power4j.tile.crypto.agreement.sm2.ExchangeRequest;
import com.power4j.tile.crypto.utils.Sm2Util;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.SM2KeyExchangePublicParameters;
import org.bouncycastle.util.encoders.Hex;

public final class Agreement {
    public static ExchangeRequest init(ExchangeContext context) {
        return context.share(null);
    }

    public static Pair<byte[], ExchangeRequest> generateKeyAndExchangeRequest(ExchangeContext context, int keyLen, ExchangeRequest request) {
        byte[][] result = context.exchanger(false).calculateKeyWithConfirmation(keyLen, null, (CipherParameters)Agreement.calculateKeyParam(request));
        assert (result.length >= 2);
        byte[] key = result[0];
        byte[] confirm = result[1];
        return Pair.of((Object)key, (Object)context.share(Hex.toHexString((byte[])confirm)));
    }

    public static byte[] generateKeyAndVerify(ExchangeContext context, int keyLen, ExchangeRequest request) {
        byte[] tag = null;
        if (StringUtils.isNotEmpty((CharSequence)request.getConfirmation())) {
            tag = Hex.decodeStrict((String)request.getConfirmation());
        }
        byte[][] result = context.exchanger(true).calculateKeyWithConfirmation(keyLen, tag, (CipherParameters)Agreement.calculateKeyParam(request));
        return result[0];
    }

    static ParametersWithID calculateKeyParam(ExchangeRequest request) {
        ECDomainParameters domainParam = Sm2Util.P256V1_DOMAIN_PARAM;
        ECPublicKeyParameters staticPubKey = new ECPublicKeyParameters(domainParam.getCurve().decodePoint(Hex.decodeStrict((String)request.getStaticPublicKey())), domainParam);
        ECPublicKeyParameters ephemeralPublicKey = new ECPublicKeyParameters(domainParam.getCurve().decodePoint(Hex.decodeStrict((String)request.getEphemeralPublicKey())), domainParam);
        byte[] userId = new byte[]{};
        if (StringUtils.isNotEmpty((CharSequence)request.getUserId())) {
            userId = Hex.decodeStrict((String)request.getUserId());
        }
        SM2KeyExchangePublicParameters exchangePublicParameters = new SM2KeyExchangePublicParameters(staticPubKey, ephemeralPublicKey);
        return new ParametersWithID((CipherParameters)exchangePublicParameters, userId);
    }

    @Generated
    private Agreement() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

