/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.agreement.sm2;

import com.power4j.tile.crypto.agreement.sm2.ExchangeRequest;
import com.power4j.tile.crypto.agreement.sm2.ExchangeStageStore;
import com.power4j.tile.crypto.utils.Sm2Util;
import java.io.PrintStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.agreement.SM2KeyExchange;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.SM2KeyExchangePrivateParameters;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.lang.Nullable;

public class ExchangeContext {
    private static final boolean COMPRESS = false;
    private final ECPrivateKeyParameters staticPrivateKey;
    private final ECPublicKeyParameters staticPublicKey;
    private final ECPrivateKeyParameters ephemeralPrivateKey;
    private final ECPublicKeyParameters ephemeralPublicKey;
    private final byte[] userId;

    public SM2KeyExchange exchanger(boolean initiator) {
        SM2KeyExchangePrivateParameters privateParameters = new SM2KeyExchangePrivateParameters(initiator, this.staticPrivateKey, this.ephemeralPrivateKey);
        SM2KeyExchange exchange = new SM2KeyExchange();
        exchange.init((CipherParameters)new ParametersWithID((CipherParameters)privateParameters, this.userId));
        return exchange;
    }

    public ExchangeStageStore stageStore() {
        ExchangeStageStore store = new ExchangeStageStore();
        store.setEphemeralPrivateKey(this.ephemeralPrivateKey.getD().toString(16));
        store.setEphemeralPublicKey(Hex.toHexString((byte[])this.ephemeralPublicKey.getQ().getEncoded(false)));
        return store;
    }

    public ExchangeRequest share(@Nullable String confirmation) {
        ExchangeRequest data = new ExchangeRequest();
        data.setStaticPublicKey(Hex.toHexString((byte[])this.staticPublicKey.getQ().getEncoded(false)));
        data.setEphemeralPublicKey(Hex.toHexString((byte[])this.ephemeralPublicKey.getQ().getEncoded(false)));
        data.setUserId(Hex.toHexString((byte[])this.userId));
        data.setConfirmation(confirmation);
        return data;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    ExchangeContext(ECPrivateKeyParameters staticPrivateKey, ECPublicKeyParameters staticPublicKey, ECPrivateKeyParameters ephemeralPrivateKey, ECPublicKeyParameters ephemeralPublicKey, byte[] userId) {
        this.staticPrivateKey = staticPrivateKey;
        this.staticPublicKey = staticPublicKey;
        this.ephemeralPrivateKey = ephemeralPrivateKey;
        this.ephemeralPublicKey = ephemeralPublicKey;
        this.userId = userId;
    }

    @Generated
    public ECPrivateKeyParameters getStaticPrivateKey() {
        return this.staticPrivateKey;
    }

    @Generated
    public ECPublicKeyParameters getStaticPublicKey() {
        return this.staticPublicKey;
    }

    @Generated
    public ECPrivateKeyParameters getEphemeralPrivateKey() {
        return this.ephemeralPrivateKey;
    }

    @Generated
    public ECPublicKeyParameters getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    @Generated
    public byte[] getUserId() {
        return this.userId;
    }

    public static class Builder {
        private byte[] staticPrivateKey;
        private byte[] staticPublicKey;
        private byte[] ephemeralPrivateKey;
        private byte[] ephemeralPublicKey;
        private byte[] userId;

        Builder() {
        }

        public Builder randomEphemeralKey() {
            KeyPair keyPair = Sm2Util.genKeyPair();
            return this.ephemeralPrivateKey(Sm2Util.extractPrivateKeyBlob(keyPair).toByteArray()).ephemeralPublicKey(Sm2Util.extractPublicKeyBlob(keyPair, false));
        }

        public Builder ephemeralPrivateKey(byte[] val) {
            this.ephemeralPrivateKey = Objects.requireNonNull(val);
            return this;
        }

        public Builder ephemeralPrivateKeyHex(String val) {
            this.ephemeralPrivateKey = Hex.decodeStrict((String)val);
            return this;
        }

        public Builder ephemeralPrivateKeyBase64(String val) {
            this.staticPrivateKey = Base64.decode((String)val);
            return this;
        }

        public Builder ephemeralPublicKey(byte[] val) {
            this.ephemeralPublicKey = Objects.requireNonNull(val);
            return this;
        }

        public Builder ephemeralPublicKeyHex(String val) {
            this.ephemeralPublicKey = Hex.decodeStrict((String)val);
            return this;
        }

        public Builder ephemeralPublicKeyBase64(String val) {
            this.ephemeralPublicKey = Base64.decode((String)val);
            return this;
        }

        public Builder staticPrivateKey(byte[] val) {
            this.staticPrivateKey = Objects.requireNonNull(val);
            return this;
        }

        public Builder staticPrivateKeyHex(String val) {
            this.staticPrivateKey = Hex.decodeStrict((String)val);
            return this;
        }

        public Builder staticPrivateKeyBase64(String val) {
            this.staticPrivateKey = Base64.decode((String)val);
            return this;
        }

        public Builder staticPublicKey(byte[] val) {
            this.staticPublicKey = Objects.requireNonNull(val);
            return this;
        }

        public Builder staticPublicKeyHex(String val) {
            this.staticPublicKey = Hex.decodeStrict((String)val);
            return this;
        }

        public Builder staticPublicKeyBase64(String val) {
            this.staticPublicKey = Base64.decode((String)val);
            return this;
        }

        public Builder userId(byte[] val) {
            this.userId = Objects.requireNonNull(val);
            return this;
        }

        public Builder userIdHex(String val) {
            this.userId = Hex.decodeStrict((String)val);
            return this;
        }

        public Builder userIdBase64(String val) {
            this.userId = Base64.decode((String)val);
            return this;
        }

        public Builder userIdUtf8(String val) {
            this.userId = val.getBytes(StandardCharsets.UTF_8);
            return this;
        }

        Builder dump(PrintStream ps, @Nullable String title) {
            if (null != title) {
                ps.println(title);
            }
            ps.println("staticPrivateKey:" + (this.staticPrivateKey == null ? "null" : Hex.toHexString((byte[])this.staticPrivateKey)));
            ps.println("staticPublicKey:" + (this.staticPublicKey == null ? "null" : Hex.toHexString((byte[])this.staticPublicKey)));
            ps.println("ephemeralPrivateKey:" + (this.ephemeralPrivateKey == null ? "null" : Hex.toHexString((byte[])this.ephemeralPrivateKey)));
            ps.println("ephemeralPublicKey:" + (this.ephemeralPublicKey == null ? "null" : Hex.toHexString((byte[])this.ephemeralPublicKey)));
            ps.println("userId:" + (this.userId == null ? "null" : Hex.toHexString((byte[])this.userId)));
            return this;
        }

        public ExchangeContext build() {
            ECDomainParameters domainParam = Sm2Util.P256V1_DOMAIN_PARAM;
            ECPrivateKeyParameters staticPri = new ECPrivateKeyParameters(new BigInteger(1, this.staticPrivateKey), domainParam);
            ECPublicKeyParameters staticPub = new ECPublicKeyParameters(domainParam.getCurve().decodePoint(this.staticPublicKey), domainParam);
            ECPrivateKeyParameters ephemeralPri = new ECPrivateKeyParameters(new BigInteger(1, this.ephemeralPrivateKey), domainParam);
            ECPublicKeyParameters ephemeralPub = new ECPublicKeyParameters(domainParam.getCurve().decodePoint(this.ephemeralPublicKey), domainParam);
            return new ExchangeContext(staticPri, staticPub, ephemeralPri, ephemeralPub, this.userId == null ? new byte[]{} : this.userId);
        }
    }

    @Generated
    public static class ExchangeContextBuilder {
        @Generated
        private ECPrivateKeyParameters staticPrivateKey;
        @Generated
        private ECPublicKeyParameters staticPublicKey;
        @Generated
        private ECPrivateKeyParameters ephemeralPrivateKey;
        @Generated
        private ECPublicKeyParameters ephemeralPublicKey;
        @Generated
        private byte[] userId;

        @Generated
        ExchangeContextBuilder() {
        }

        @Generated
        public ExchangeContextBuilder staticPrivateKey(ECPrivateKeyParameters staticPrivateKey) {
            this.staticPrivateKey = staticPrivateKey;
            return this;
        }

        @Generated
        public ExchangeContextBuilder staticPublicKey(ECPublicKeyParameters staticPublicKey) {
            this.staticPublicKey = staticPublicKey;
            return this;
        }

        @Generated
        public ExchangeContextBuilder ephemeralPrivateKey(ECPrivateKeyParameters ephemeralPrivateKey) {
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            return this;
        }

        @Generated
        public ExchangeContextBuilder ephemeralPublicKey(ECPublicKeyParameters ephemeralPublicKey) {
            this.ephemeralPublicKey = ephemeralPublicKey;
            return this;
        }

        @Generated
        public ExchangeContextBuilder userId(byte[] userId) {
            this.userId = userId;
            return this;
        }

        @Generated
        public ExchangeContext build() {
            return new ExchangeContext(this.staticPrivateKey, this.staticPublicKey, this.ephemeralPrivateKey, this.ephemeralPublicKey, this.userId);
        }

        @Generated
        public String toString() {
            return "ExchangeContext.ExchangeContextBuilder(staticPrivateKey=" + this.staticPrivateKey + ", staticPublicKey=" + this.staticPublicKey + ", ephemeralPrivateKey=" + this.ephemeralPrivateKey + ", ephemeralPublicKey=" + this.ephemeralPublicKey + ", userId=" + Arrays.toString(this.userId) + ")";
        }
    }
}

