/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.bc;

import com.power4j.tile.crypto.core.CipherBlobDetails;
import com.power4j.tile.crypto.core.GeneralCryptoException;
import com.power4j.tile.crypto.core.QuickCipher;
import com.power4j.tile.crypto.core.Slice;
import com.power4j.tile.crypto.core.UncheckedCipher;
import com.power4j.tile.crypto.core.Verified;
import com.power4j.tile.crypto.utils.CryptoUtil;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.lang.Nullable;

public class BouncyCastleQuickCipher
implements QuickCipher {
    private final Cipher cipher;
    private final Supplier<SecretKeySpec> keySupplier;
    private final Supplier<IvParameterSpec> ivParameterSpecSupplier;
    private final String[] transformationParts;
    private final Function<byte[], byte[]> checksumCalculator;
    private final BiFunction<UncheckedCipher, byte[], Boolean> checksumVerifier;

    public BouncyCastleQuickCipher(String transformation, Supplier<SecretKeySpec> keySupplier, Supplier<IvParameterSpec> ivParameterSpecSupplier, Function<byte[], byte[]> checksumCalculator, BiFunction<UncheckedCipher, byte[], Boolean> checksumVerifier) {
        this.cipher = CryptoUtil.createCipher(transformation);
        this.keySupplier = keySupplier;
        this.ivParameterSpecSupplier = ivParameterSpecSupplier;
        this.checksumCalculator = checksumCalculator;
        this.checksumVerifier = checksumVerifier;
        this.transformationParts = transformation.split("/");
    }

    @Override
    public CipherBlobDetails encrypt(byte[] data, int offset, int length) throws GeneralCryptoException {
        byte[] encrypted;
        byte[] checksum;
        IvParameterSpec ivParameter = this.ivParameterSpecSupplier.get();
        try {
            checksum = this.checksumCalculator.apply(data);
            encrypted = this.oneStep(1, this.keySupplier.get(), ivParameter, Slice.wrap(data));
        }
        catch (Exception e) {
            throw CryptoUtil.wrapGeneralCryptoException(null, e);
        }
        byte[] ivBytes = ivParameter == null ? null : ivParameter.getIV();
        return CipherBlobDetails.builder().algorithm(this.transformationParts[0]).mode(this.transformationParts[1]).padding(this.transformationParts[2]).iv(ivBytes).checksum(checksum).cipher(encrypted).build();
    }

    @Override
    public Verified<byte[]> decrypt(UncheckedCipher input, boolean skipCheck) throws GeneralCryptoException {
        byte[] decrypted;
        try {
            decrypted = this.oneStep(2, this.keySupplier.get(), this.ivParameterSpecSupplier.get(), input.getCipher());
        }
        catch (GeneralSecurityException e) {
            return Verified.fail(null, e);
        }
        if (skipCheck) {
            return Verified.pass(decrypted);
        }
        return this.checksumVerifier.apply(input, decrypted) != false ? Verified.pass(decrypted) : Verified.fail(decrypted, null);
    }

    protected final synchronized byte[] oneStep(int mode, SecretKeySpec key, @Nullable IvParameterSpec iv, Slice data) throws GeneralSecurityException {
        this.cipher.init(mode, (Key)key, iv);
        return this.cipher.doFinal(data.getData(), data.getOffset(), data.getLength());
    }
}

