/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.core;

import java.util.Optional;
import org.springframework.lang.Nullable;

public enum BufferEncoding {
    ASCII("ASCII"),
    UTF_8("UTF_8"),
    UTF_16LE("UTF_16LE"),
    UTF_16BE("UTF_16BE"),
    HEX("HEX"),
    BASE64("BASE64"),
    BASE64_URL("BASE64_URL");

    private final String value;

    private BufferEncoding(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Optional<BufferEncoding> parse(@Nullable String value) {
        if (value == null) {
            return Optional.empty();
        }
        for (BufferEncoding o : BufferEncoding.values()) {
            if (!o.getValue().equals(value)) continue;
            return Optional.of(o);
        }
        return Optional.empty();
    }

    public static BufferEncoding fromValue(@Nullable String value) throws IllegalArgumentException {
        return BufferEncoding.parse(value).orElseThrow(() -> new IllegalArgumentException("Invalid value : " + value));
    }
}

