/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.core;

import com.power4j.tile.crypto.bc.BouncyCastleQuickCipher;
import com.power4j.tile.crypto.core.UncheckedCipher;
import com.power4j.tile.crypto.utils.CryptoUtil;
import com.power4j.tile.crypto.utils.Validate;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.lang.Nullable;

public class QuickCipherBuilder {
    private final String algorithmName;
    private String mode;
    private String padding;
    private Supplier<SecretKeySpec> secretKeySpecSupplier;
    private Supplier<IvParameterSpec> ivParameterSpecSupplier;
    private Function<byte[], byte[]> checksumCalculator;
    private BiFunction<UncheckedCipher, byte[], Boolean> checksumVerifier;

    QuickCipherBuilder(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public static QuickCipherBuilder algorithm(String algorithmName) {
        return new QuickCipherBuilder(algorithmName);
    }

    public QuickCipherBuilder mode(String mode) {
        this.mode = mode;
        return this;
    }

    public QuickCipherBuilder padding(String padding) {
        this.padding = padding;
        return this;
    }

    public QuickCipherBuilder secretKeySpecSupplier(Supplier<SecretKeySpec> supplier) {
        this.secretKeySpecSupplier = supplier;
        return this;
    }

    public QuickCipherBuilder secretKey(byte[] key) {
        return this.secretKeySpecSupplier(() -> CryptoUtil.createKey(key, this.algorithmName));
    }

    public QuickCipherBuilder secretKeyHex(String val) {
        this.secretKeySpecSupplier = () -> CryptoUtil.createKey(CryptoUtil.decodeHex(val, null), this.algorithmName);
        return this;
    }

    public QuickCipherBuilder secretKeyBase64(String val) {
        this.secretKeySpecSupplier = () -> CryptoUtil.createKey(CryptoUtil.decodeBase64(val, null), this.algorithmName);
        return this;
    }

    public QuickCipherBuilder ivParameterSpecSupplier(Supplier<IvParameterSpec> supplier) {
        this.ivParameterSpecSupplier = supplier;
        return this;
    }

    public QuickCipherBuilder ivParameter(@Nullable byte[] iv) {
        if (iv == null) {
            return this.ivParameterSpecSupplier(() -> null);
        }
        return this.ivParameterSpecSupplier(() -> new IvParameterSpec(iv));
    }

    public QuickCipherBuilder ivParameterHex(@Nullable String val) {
        if (val == null) {
            return this.ivParameterSpecSupplier(() -> null);
        }
        return this.ivParameterSpecSupplier(() -> new IvParameterSpec(CryptoUtil.decodeHex(val, null)));
    }

    public QuickCipherBuilder ivParameterBase64(String val) {
        this.ivParameterSpecSupplier = () -> new IvParameterSpec(CryptoUtil.decodeBase64(val, null));
        return this;
    }

    public QuickCipherBuilder checksumCalculator(@Nullable Function<byte[], byte[]> calculator) {
        this.checksumCalculator = calculator;
        return this;
    }

    public QuickCipherBuilder sm3ChecksumCalculator() {
        this.checksumCalculator = CryptoUtil.SM3_CHECKSUM_CALCULATOR;
        return this;
    }

    public QuickCipherBuilder checksumVerifier(BiFunction<UncheckedCipher, byte[], Boolean> verifier) {
        this.checksumVerifier = verifier;
        return this;
    }

    public QuickCipherBuilder sm3ChecksumVerifier() {
        this.checksumVerifier = CryptoUtil.SM3_CHECKSUM_VERIFIER;
        return this;
    }

    public BouncyCastleQuickCipher build() {
        Validate.notEmpty(this.algorithmName, "algorithmName must not be empty");
        Validate.notEmpty(this.mode, "mode must not be empty");
        Validate.notEmpty(this.padding, "padding must not be empty");
        Validate.notNull(this.secretKeySpecSupplier, "secretKeySpecSupplier must not be null");
        Function<byte[], byte[]> calculator = this.checksumCalculator == null ? CryptoUtil.EMPTY_CHECKSUM_CALCULATOR : this.checksumCalculator;
        BiFunction<UncheckedCipher, byte[], Boolean> verifier = this.checksumVerifier == null ? CryptoUtil.IGNORED_CHECKSUM_VERIFIER : this.checksumVerifier;
        Supplier<IvParameterSpec> ivSpecSupplier = this.ivParameterSpecSupplier == null ? () -> null : this.ivParameterSpecSupplier;
        String transformation = CryptoUtil.transformation(this.algorithmName, this.mode, this.padding);
        return new BouncyCastleQuickCipher(transformation, this.secretKeySpecSupplier, ivSpecSupplier, calculator, verifier);
    }
}

