/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.core;

import com.power4j.tile.crypto.core.GeneralCryptoException;
import com.power4j.tile.crypto.core.UncheckedCipher;
import com.power4j.tile.crypto.core.Verified;
import com.power4j.tile.crypto.core.encode.HexEncoder;
import com.power4j.tile.crypto.utils.CryptoUtil;
import com.power4j.tile.crypto.wrapper.InputDecoder;
import com.power4j.tile.crypto.wrapper.OutputEncoder;

public interface QuickDec {
    default public byte[] decrypt(byte[] data) throws GeneralCryptoException {
        Verified<byte[]> result = this.decrypt(UncheckedCipher.of(data), true);
        if (!result.isPass()) {
            Throwable throwable = result.getCause();
            if (throwable != null) {
                throw CryptoUtil.wrapGeneralCryptoException("Data verification failed", throwable);
            }
            throw new GeneralCryptoException("Data verification failed");
        }
        if (!1.$assertionsDisabled && result.getData() == null) {
            throw new AssertionError();
        }
        return result.getData();
    }

    public Verified<byte[]> decrypt(UncheckedCipher var1, boolean var2) throws GeneralCryptoException;

    default public <T, R> R decryptWith(InputDecoder<T> decoder, OutputEncoder<R> encoder, T input) throws GeneralCryptoException {
        byte[] data = decoder.decode(input);
        return encoder.encode(this.decrypt(data));
    }

    default public byte[] decryptHex(String data) throws GeneralCryptoException {
        return this.decryptWith(HexEncoder.DEFAULT::decode, OutputEncoder.NO_OP, data);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

