/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.core;

import java.util.Arrays;
import lombok.Generated;
import org.springframework.lang.Nullable;

public class Slice {
    private final byte[] data;
    private final int offset;
    private final int length;

    public static Slice wrap(@Nullable byte[] data) {
        if (data == null) {
            return Slice.range(new byte[0], 0, 0);
        }
        return Slice.range(data, 0, data.length);
    }

    public static Slice range(byte[] data, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException("Illegal offset or length");
        }
        return new Slice(data, offset, length);
    }

    public static Slice remaining(byte[] data, int offset) {
        return Slice.range(data, offset, data.length - offset);
    }

    public static Slice copyOf(byte[] data) {
        return Slice.copyOfRange(data, 0, data.length);
    }

    public static Slice copyOfRange(byte[] data, int offset, int length) {
        return Slice.wrap(Arrays.copyOfRange(data, offset, offset + length));
    }

    public static Slice copyOfRemaining(byte[] data, int offset) {
        return Slice.copyOfRange(data, offset, data.length - offset);
    }

    public boolean dataEquals(Slice other) {
        return this.dataEquals(other.data, other.offset, other.length);
    }

    public byte[] unwrap() {
        return Arrays.copyOfRange(this.data, this.offset, this.offset + this.length);
    }

    public Slice sub(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.length) {
            throw new IllegalArgumentException("Illegal offset or length");
        }
        return new Slice(this.data, this.offset + offset, length);
    }

    public boolean dataEquals(byte[] other) {
        return this.dataEquals(other, 0, other.length);
    }

    public boolean dataEquals(byte[] other, int otherOffset, int otherLength) {
        if (this.length != otherLength) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.data[this.offset + i] == other[otherOffset + i]) continue;
            return false;
        }
        return true;
    }

    @Generated
    public byte[] getData() {
        return this.data;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Generated
    public int getLength() {
        return this.length;
    }

    @Generated
    public Slice(byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }
}

