/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.core;

import com.power4j.tile.crypto.bc.BouncyCastleQuickCipher;
import com.power4j.tile.crypto.bc.GlobalBouncyCastleProvider;
import com.power4j.tile.crypto.core.BufferEncoding;
import com.power4j.tile.crypto.core.CipherBlobDetails;
import com.power4j.tile.crypto.core.CiphertextDetails;
import com.power4j.tile.crypto.core.GeneralCryptoException;
import com.power4j.tile.crypto.core.QuickCipherBuilder;
import com.power4j.tile.crypto.core.TextCipher;
import com.power4j.tile.crypto.core.encode.Base64Encoder;
import com.power4j.tile.crypto.core.encode.BufferEncoder;
import com.power4j.tile.crypto.core.encode.HexEncoder;
import com.power4j.tile.crypto.core.encode.UnicodeEncoder;
import java.security.GeneralSecurityException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.crypto.Cipher;
import lombok.Generated;
import org.springframework.lang.Nullable;

public class TextCipherBuilder {
    private static final Function<byte[], byte[]> HASH_NONE = b -> new byte[0];
    private final QuickCipherBuilder quickCipherBuilder;
    private BufferEncoder inputEncoder;
    private BufferEncoder outputEncoder;

    public TextCipherBuilder(QuickCipherBuilder quickCipherBuilder) {
        this.quickCipherBuilder = quickCipherBuilder;
    }

    public static TextCipherBuilder of(String algorithmName, String mode, String padding) {
        QuickCipherBuilder builder = QuickCipherBuilder.algorithm(algorithmName).mode(mode).padding(padding);
        return new TextCipherBuilder(builder);
    }

    public static TextCipherBuilder sm4Ecb() {
        return TextCipherBuilder.of("SM4", "ECB", "PKCS7Padding");
    }

    public static TextCipherBuilder sm4Cbc() {
        return TextCipherBuilder.of("SM4", "CBC", "PKCS7Padding");
    }

    public static TextCipherBuilder sm4Cfb() {
        return TextCipherBuilder.of("SM4", "CFB", "NoPadding");
    }

    public static TextCipherBuilder sm4Ofb() {
        return TextCipherBuilder.of("SM4", "OFB", "NoPadding");
    }

    public TextCipherBuilder cipher(Consumer<QuickCipherBuilder> consumer) {
        consumer.accept(this.quickCipherBuilder);
        return this;
    }

    public TextCipherBuilder inputEncoding(BufferEncoding inputEncoding) {
        this.inputEncoder = this.getEncoder(inputEncoding);
        return this;
    }

    public TextCipherBuilder inputEncoding(BufferEncoder encoder) {
        this.inputEncoder = encoder;
        return this;
    }

    public TextCipherBuilder outputEncoding(BufferEncoding outputEncoding) {
        this.outputEncoder = this.getEncoder(outputEncoding);
        return this;
    }

    public TextCipherBuilder outputEncoding(BufferEncoder encoder) {
        this.outputEncoder = encoder;
        return this;
    }

    public TextCipherBuilder reversedEncoder() {
        return new TextCipherBuilder(this.quickCipherBuilder).inputEncoding(this.outputEncoder).outputEncoding(this.inputEncoder);
    }

    public TextCipher build() {
        BouncyCastleQuickCipher cipher = this.quickCipherBuilder.build();
        return BouncyCastleTextCipher.builder().cipher(cipher).inputEncoder(this.inputEncoder).outputEncoder(this.outputEncoder).build();
    }

    protected static boolean isEmpty(@Nullable byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    protected BufferEncoder getEncoder(BufferEncoding encoding) {
        switch (encoding) {
            case ASCII: {
                return UnicodeEncoder.US_ASCII;
            }
            case UTF_8: {
                return UnicodeEncoder.UTF_8;
            }
            case UTF_16LE: {
                return UnicodeEncoder.UTF_16LE;
            }
            case UTF_16BE: {
                return UnicodeEncoder.UTF_16BE;
            }
            case HEX: {
                return HexEncoder.DEFAULT;
            }
            case BASE64: {
                return Base64Encoder.BASIC;
            }
            case BASE64_URL: {
                return Base64Encoder.URL_SAFE;
            }
        }
        throw new IllegalArgumentException("Unsupported encoding: " + (Object)((Object)encoding));
    }

    static class BouncyCastleTextCipher
    implements TextCipher {
        private final BufferEncoder inputEncoder;
        private final BufferEncoder outputEncoder;
        private final BouncyCastleQuickCipher cipher;

        @Override
        public String encrypt(String data) throws GeneralCryptoException {
            return this.outputEncoder.encode(this.encryptData(this.inputEncoder.decode(data)));
        }

        @Override
        public CiphertextDetails encryptEnvelope(String data) throws GeneralCryptoException {
            CipherBlobDetails details = this.cipher.encrypt(this.inputEncoder.decode(data));
            String iv = details.getIvOptional().map(this.outputEncoder::encode).orElse(null);
            return CiphertextDetails.builder().encoding(this.outputEncoder.algorithm()).algorithm(details.getAlgorithm()).mode(details.getMode()).padding(details.getPadding()).ciphertext(this.outputEncoder.encode(details.getCipher())).iv(iv).checksum(this.outputEncoder.encode(details.getChecksum())).build();
        }

        @Override
        public String decrypt(String data) throws GeneralCryptoException {
            return this.outputEncoder.encode(this.decryptData(this.inputEncoder.decode(data)));
        }

        private byte[] encryptData(byte[] data) throws GeneralCryptoException {
            return this.cipher.encrypt(data).getCipher();
        }

        private byte[] decryptData(byte[] data) throws GeneralCryptoException {
            return this.cipher.decrypt(data);
        }

        private static Cipher createCipher(String transformation) throws GeneralSecurityException {
            return Cipher.getInstance(transformation, GlobalBouncyCastleProvider.INSTANCE.getProvider());
        }

        @Generated
        BouncyCastleTextCipher(BufferEncoder inputEncoder, BufferEncoder outputEncoder, BouncyCastleQuickCipher cipher) {
            this.inputEncoder = inputEncoder;
            this.outputEncoder = outputEncoder;
            this.cipher = cipher;
        }

        @Generated
        public static BouncyCastleTextCipherBuilder builder() {
            return new BouncyCastleTextCipherBuilder();
        }

        @Generated
        public static class BouncyCastleTextCipherBuilder {
            @Generated
            private BufferEncoder inputEncoder;
            @Generated
            private BufferEncoder outputEncoder;
            @Generated
            private BouncyCastleQuickCipher cipher;

            @Generated
            BouncyCastleTextCipherBuilder() {
            }

            @Generated
            public BouncyCastleTextCipherBuilder inputEncoder(BufferEncoder inputEncoder) {
                this.inputEncoder = inputEncoder;
                return this;
            }

            @Generated
            public BouncyCastleTextCipherBuilder outputEncoder(BufferEncoder outputEncoder) {
                this.outputEncoder = outputEncoder;
                return this;
            }

            @Generated
            public BouncyCastleTextCipherBuilder cipher(BouncyCastleQuickCipher cipher) {
                this.cipher = cipher;
                return this;
            }

            @Generated
            public BouncyCastleTextCipher build() {
                return new BouncyCastleTextCipher(this.inputEncoder, this.outputEncoder, this.cipher);
            }

            @Generated
            public String toString() {
                return "TextCipherBuilder.BouncyCastleTextCipher.BouncyCastleTextCipherBuilder(inputEncoder=" + this.inputEncoder + ", outputEncoder=" + this.outputEncoder + ", cipher=" + this.cipher + ")";
            }
        }
    }
}

